/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.ArrayList;
import javax.inject.Singleton;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.omid.tso.Batch;
import org.apache.omid.tso.TSOServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPoolModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPoolModule.class);
    private final TSOServerConfig config;

    public BatchPoolModule(TSOServerConfig config) {
        this.config = config;
    }

    protected void configure() {
    }

    @Provides
    @Singleton
    ObjectPool<Batch> getBatchPool() throws Exception {
        int poolSize = this.config.getNumConcurrentCTWriters();
        int batchSize = this.config.getBatchSizePerCTWriter();
        LOG.info("Pool Size (# of Batches) {}; Batch Size {}", (Object)poolSize, (Object)batchSize);
        LOG.info("Total Batch Size (Pool size * Batch Size): {}", (Object)(poolSize * batchSize));
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(poolSize);
        config.setMaxIdle(poolSize + 1);
        config.setBlockWhenExhausted(true);
        GenericObjectPool batchPool = new GenericObjectPool((PooledObjectFactory)new Batch.BatchFactory(batchSize), config);
        LOG.info("Pre-creating objects in the pool...");
        ArrayList<Object> batches = new ArrayList<Object>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            batches.add(batchPool.borrowObject());
        }
        for (Batch batch : batches) {
            batchPool.returnObject((Object)batch);
        }
        return batchPool;
    }
}

