/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import org.apache.omid.HBaseConfigModule;
import org.apache.omid.tso.LeaseManagement;
import org.apache.omid.tso.TSOChannelHandler;
import org.apache.omid.tso.TSOStateManager;
import org.apache.omid.tso.VoidLeaseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoidLeaseManagementModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(VoidLeaseManagementModule.class);
    private String keytab;
    private String principal;
    private String tableName = "OMID_TIMESTAMP_TABLE";

    protected void configure() {
        LOG.info(this.toString());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"omid.timestampstorage.tablename")).to(this.tableName);
        this.install((Module)new HBaseConfigModule(this.principal, this.keytab));
    }

    @Provides
    @Singleton
    LeaseManagement provideLeaseManager(TSOChannelHandler tsoChannelHandler, TSOStateManager stateManager) throws LeaseManagement.LeaseManagementException {
        return new VoidLeaseManager(tsoChannelHandler, stateManager);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public void setKeytab(String keytab) {
        this.keytab = keytab;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VoidLeaseManagementModule{");
        sb.append("keytab='").append(this.keytab).append('\'');
        sb.append(", principal='").append(this.principal).append('\'');
        sb.append(", tableName='").append(this.tableName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

