/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.Collections;
import org.apache.phoenix.compile.BaseMutationPlan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.OpenStatement;
import org.apache.phoenix.schema.MetaDataClient;

public class OpenStatementCompiler {
    private final PhoenixStatement statement;
    private final PhoenixStatement.Operation operation;

    public OpenStatementCompiler(PhoenixStatement statement, PhoenixStatement.Operation operation) {
        this.statement = statement;
        this.operation = operation;
    }

    public MutationPlan compile(final OpenStatement open) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        StatementContext context = new StatementContext(this.statement);
        final MetaDataClient client = new MetaDataClient(connection);
        return new BaseMutationPlan(context, this.operation){

            @Override
            public MutationState execute() throws SQLException {
                return client.open(open);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("OPEN CURSOR"));
            }
        };
    }
}

