/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;

public class DistinctValueClientAggregator
extends DistinctValueWithCountClientAggregator {
    private final PDataType valueType;
    private final PDataType resultType;

    public DistinctValueClientAggregator(SortOrder sortOrder, PDataType valueType, PDataType resultType) {
        super(sortOrder);
        this.valueType = valueType;
        this.resultType = resultType;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.cachedResult == null) {
            Object[] values = new Object[this.valueVsCount.size()];
            int i = 0;
            for (ImmutableBytesPtr key : this.valueVsCount.keySet()) {
                values[i++] = this.valueType.toObject((ImmutableBytesWritable)key, this.sortOrder);
            }
            this.cachedResult = PArrayDataType.instantiatePhoenixArray(this.valueType, values);
        }
        this.buffer = this.resultType.toBytes(this.cachedResult, this.sortOrder);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    protected PDataType getResultDataType() {
        return this.resultType;
    }

    @Override
    protected int getBufferLength() {
        return 0;
    }
}

