/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagRewriteCell;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.phoenix.compat.hbase.HbaseCompatCapabilities;
import org.apache.phoenix.compat.hbase.coprocessor.CompatIndexRegionObserver;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.coprocessor.DelegateRegionCoprocessorEnvironment;
import org.apache.phoenix.coprocessor.GlobalIndexRegionScanner;
import org.apache.phoenix.coprocessor.IndexRebuildRegionScanner;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.LockManager;
import org.apache.phoenix.hbase.index.MultiMutation;
import org.apache.phoenix.hbase.index.builder.IndexBuildManager;
import org.apache.phoenix.hbase.index.builder.IndexBuilder;
import org.apache.phoenix.hbase.index.covered.IndexMetaData;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSource;
import org.apache.phoenix.hbase.index.metrics.MetricsIndexerSourceFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.hbase.index.util.IndexManagementUtil;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.LazyParallelWriterIndexCommitter;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.PhoenixIndexMetaData;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.trace.TracingUtils;
import org.apache.phoenix.trace.util.NullSpan;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.apache.phoenix.util.WALAnnotationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRegionObserver
extends CompatIndexRegionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRegionObserver.class);
    private static final OperationStatus IGNORE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    private static final OperationStatus NOWRITE = new OperationStatus(HConstants.OperationStatusCode.SUCCESS);
    protected static final byte VERIFIED_BYTE = 1;
    protected static final byte UNVERIFIED_BYTE = 2;
    public static final byte[] UNVERIFIED_BYTES = new byte[]{2};
    public static final byte[] VERIFIED_BYTES = new byte[]{1};
    public static final String PHOENIX_APPEND_METADATA_TO_WAL = "phoenix.append.metadata.to.wal";
    public static final boolean DEFAULT_PHOENIX_APPEND_METADATA_TO_WAL = false;
    private static boolean failPreIndexUpdatesForTesting = false;
    private static boolean failPostIndexUpdatesForTesting = false;
    private static boolean failDataTableUpdatesForTesting = false;
    private ThreadLocal<BatchMutateContext> batchMutateContext = new ThreadLocal();
    public static final String INDEX_BUILDER_CONF_KEY = "index.builder";
    public static final String CHECK_VERSION_CONF_KEY = "com.saleforce.hbase.index.checkversion";
    public static final String INDEX_LAZY_POST_BATCH_WRITE = "org.apache.hadoop.hbase.index.lazy.post_batch.write";
    private static final boolean INDEX_LAZY_POST_BATCH_WRITE_DEFAULT = false;
    private static final String INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.post.batch.mutate.threshold";
    private static final long INDEXER_INDEX_WRITE_SLOW_THRESHOLD_DEFAULT = 3000L;
    private static final String INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY = "phoenix.indexer.slow.pre.increment";
    private static final long INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_DEFAULT = 3000L;
    protected IndexWriter preWriter;
    protected IndexWriter postWriter;
    protected IndexBuildManager builder;
    private LockManager lockManager;
    private Map<ImmutableBytesPtr, PendingRow> pendingRows = new ConcurrentHashMap<ImmutableBytesPtr, PendingRow>();
    private MetricsIndexerSource metricSource;
    private boolean stopped;
    private boolean disabled;
    private long slowIndexPrepareThreshold;
    private long slowPreIncrementThreshold;
    private int rowLockWaitDuration;
    private int concurrentMutationWaitDuration;
    private String dataTableName;
    private boolean shouldWALAppend = false;
    private boolean isNamespaceEnabled = false;
    private static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    private static final int DEFAULT_CONCURRENT_MUTATION_WAIT_DURATION_IN_MS = 100;

    public static void setFailPreIndexUpdatesForTesting(boolean fail) {
        failPreIndexUpdatesForTesting = fail;
    }

    public static void setFailPostIndexUpdatesForTesting(boolean fail) {
        failPostIndexUpdatesForTesting = fail;
    }

    public static void setFailDataTableUpdatesForTesting(boolean fail) {
        failDataTableUpdatesForTesting = fail;
    }

    public void start(CoprocessorEnvironment e) throws IOException {
        try {
            String errormsg;
            RegionCoprocessorEnvironment env = (RegionCoprocessorEnvironment)e;
            String serverName = env.getRegionServerServices().getServerName().getServerName();
            if (env.getConfiguration().getBoolean(CHECK_VERSION_CONF_KEY, true) && (errormsg = Indexer.validateVersion(env.getHBaseVersion(), env.getConfiguration())) != null) {
                IOException ioe = new IOException(errormsg);
                env.getRegionServerServices().abort(errormsg, (Throwable)ioe);
                throw ioe;
            }
            this.builder = new IndexBuildManager(env);
            DelegateRegionCoprocessorEnvironment indexWriterEnv = new DelegateRegionCoprocessorEnvironment(env, ServerUtil.ConnectionType.INDEX_WRITER_CONNECTION);
            this.preWriter = new IndexWriter(indexWriterEnv, serverName + "-index-preWriter", false);
            this.postWriter = env.getConfiguration().getBoolean(INDEX_LAZY_POST_BATCH_WRITE, false) ? new IndexWriter(indexWriterEnv, new LazyParallelWriterIndexCommitter(), serverName + "-index-postWriter", false) : this.preWriter;
            this.rowLockWaitDuration = env.getConfiguration().getInt("hbase.rowlock.wait.duration", 30000);
            this.lockManager = new LockManager();
            this.concurrentMutationWaitDuration = env.getConfiguration().getInt("phoenix.index.concurrent.wait.duration.ms", 100);
            this.metricSource = MetricsIndexerSourceFactory.getInstance().getIndexerSource();
            this.setSlowThresholds(e.getConfiguration());
            this.dataTableName = env.getRegionInfo().getTable().getNameAsString();
            this.shouldWALAppend = env.getConfiguration().getBoolean(PHOENIX_APPEND_METADATA_TO_WAL, false);
            this.isNamespaceEnabled = SchemaUtil.isNamespaceMappingEnabled(PTableType.INDEX, env.getConfiguration());
        }
        catch (NoSuchMethodError ex) {
            this.disabled = true;
            super.start(e);
            LOG.error("Must be too early a version of HBase. Disabled coprocessor ", (Throwable)ex);
        }
    }

    private void setSlowThresholds(Configuration c) {
        this.slowIndexPrepareThreshold = c.getLong(INDEXER_INDEX_WRITE_SLOW_THRESHOLD_KEY, 3000L);
        this.slowPreIncrementThreshold = c.getLong(INDEXER_PRE_INCREMENT_SLOW_THRESHOLD_KEY, 3000L);
    }

    private String getCallTooSlowMessage(String callName, long duration, long threshold) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("(callTooSlow) ").append(callName).append(" duration=").append(duration);
        sb.append("ms, threshold=").append(threshold).append("ms");
        return sb.toString();
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
        if (this.stopped) {
            return;
        }
        if (this.disabled) {
            return;
        }
        this.stopped = true;
        String msg = "Indexer is being stopped";
        this.builder.stop(msg);
        this.preWriter.stop(msg);
        this.postWriter.stop(msg);
    }

    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Increment inc) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            List<Mutation> mutations = this.builder.executeAtomicOp(inc);
            if (mutations == null) {
                Result result = null;
                return result;
            }
            e.bypass();
            e.complete();
            if (!mutations.isEmpty()) {
                Region region = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
                region.batchMutate(mutations.toArray(new Mutation[0]), 0L, 0L);
            }
            Result result = Result.EMPTY_RESULT;
            return result;
        }
        catch (Throwable t) {
            throw ServerUtil.createIOException("Unable to process ON DUPLICATE IGNORE for " + ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString() + "(" + Bytes.toStringBinary((byte[])inc.getRow()) + ")", t);
        }
        finally {
            long duration = EnvironmentEdgeManager.currentTimeMillis() - start;
            if (duration >= this.slowIndexPrepareThreshold) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getCallTooSlowMessage("preIncrementAfterRowLock", duration, this.slowPreIncrementThreshold));
                }
                this.metricSource.incrementSlowDuplicateKeyCheckCalls(this.dataTableName);
            }
            this.metricSource.updateDuplicateKeyCheckTime(this.dataTableName, duration);
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (this.disabled) {
            return;
        }
        try {
            this.preBatchMutateWithExceptions(c, miniBatchOp);
            return;
        }
        catch (Throwable t) {
            IndexManagementUtil.rethrowIndexingException(t);
            throw new RuntimeException("Somehow didn't return an index update but also didn't propagate the failure to the client!");
        }
    }

    public static long getMaxTimestamp(Mutation m) {
        long maxTs = 0L;
        for (List cells : m.getFamilyCellMap().values()) {
            for (Cell cell : cells) {
                long ts = cell.getTimestamp();
                if (ts <= maxTs) continue;
                maxTs = ts;
            }
        }
        return maxTs;
    }

    private void ignoreAtomicOperations(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (!this.builder.isAtomicOp(m)) continue;
            miniBatchOp.setOperationStatus(i, IGNORE);
        }
    }

    private void populateRowsToLock(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m;
            if (miniBatchOp.getOperationStatus(i) == IGNORE || !this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i))) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            if (context.rowsToLock.contains((Object)row)) continue;
            context.rowsToLock.add(row);
        }
    }

    private void lockRows(BatchMutateContext context) throws IOException {
        for (ImmutableBytesPtr rowKey : context.rowsToLock) {
            context.rowLocks.add(this.lockManager.lockRow(rowKey, this.rowLockWaitDuration));
        }
    }

    private void unlockRows(BatchMutateContext context) throws IOException {
        for (LockManager.RowLock rowLock : context.rowLocks) {
            rowLock.release();
        }
        context.rowLocks.clear();
    }

    private void populatePendingRows(BatchMutateContext context) {
        for (LockManager.RowLock rowLock : context.rowLocks) {
            ImmutableBytesPtr rowKey = rowLock.getRowKey();
            PendingRow pendingRow = this.pendingRows.get((Object)rowKey);
            if (pendingRow == null) {
                this.pendingRows.put(rowKey, new PendingRow(context));
                continue;
            }
            pendingRow.add(context);
        }
    }

    private Collection<? extends Mutation> groupMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        context.multiMutationMap = new HashMap();
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (miniBatchOp.getOperationStatus(i) == IGNORE || !this.builder.isEnabled(m)) continue;
            ImmutableBytesPtr row = new ImmutableBytesPtr(m.getRow());
            MultiMutation stored = (MultiMutation)((Object)context.multiMutationMap.get((Object)row));
            if (stored == null) {
                stored = new MultiMutation(row);
                context.multiMutationMap.put(row, stored);
            }
            stored.addAll(m);
        }
        return context.multiMutationMap.values();
    }

    public static void setTimestamps(MiniBatchOperationInProgress<Mutation> miniBatchOp, IndexBuildManager builder, long ts) throws IOException {
        Integer i = 0;
        while (i < miniBatchOp.size()) {
            Mutation m;
            if (miniBatchOp.getOperationStatus(i.intValue()) != IGNORE && builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i.intValue()))) {
                for (List cells : m.getFamilyCellMap().values()) {
                    for (Cell cell : cells) {
                        CellUtil.setTimestamp((Cell)cell, (long)ts);
                    }
                }
            }
            Integer n = i;
            i = i + 1;
            Integer n2 = i;
        }
    }

    private void applyPendingDeleteMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            Put nextDataRowState;
            Mutation m;
            if (miniBatchOp.getOperationStatus(i) == IGNORE || !this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i)) || !(m instanceof Delete)) continue;
            ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(m.getRow());
            Pair dataRowState = (Pair)context.dataRowStates.get((Object)rowKeyPtr);
            if (dataRowState == null) {
                dataRowState = new Pair(null, null);
                context.dataRowStates.put(rowKeyPtr, dataRowState);
            }
            if ((nextDataRowState = (Put)dataRowState.getSecond()) == null) {
                if (dataRowState.getFirst() != null) continue;
                miniBatchOp.setOperationStatus(i, NOWRITE);
                continue;
            }
            for (List cells : m.getFamilyCellMap().values()) {
                for (Cell cell : cells) {
                    switch (KeyValue.Type.codeToType((byte)cell.getTypeByte())) {
                        case DeleteFamily: 
                        case DeleteFamilyVersion: {
                            nextDataRowState.getFamilyCellMap().remove(CellUtil.cloneFamily((Cell)cell));
                            break;
                        }
                        case DeleteColumn: 
                        case Delete: {
                            IndexRebuildRegionScanner.removeColumn(nextDataRowState, cell);
                        }
                    }
                }
            }
            if (nextDataRowState == null || nextDataRowState.getFamilyCellMap().size() != 0) continue;
            dataRowState.setSecond(null);
        }
    }

    private void applyPendingPutMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context, long now) throws IOException {
        Integer i = 0;
        while (i < miniBatchOp.size()) {
            Mutation m;
            if (miniBatchOp.getOperationStatus(i.intValue()) != IGNORE && this.builder.isEnabled(m = (Mutation)miniBatchOp.getOperation(i.intValue())) && m instanceof Put) {
                Put nextDataRowState;
                ImmutableBytesPtr rowKeyPtr = new ImmutableBytesPtr(m.getRow());
                Pair dataRowState = (Pair)context.dataRowStates.get((Object)rowKeyPtr);
                if (dataRowState == null) {
                    dataRowState = new Pair(null, null);
                    context.dataRowStates.put(rowKeyPtr, dataRowState);
                }
                dataRowState.setSecond((Object)((nextDataRowState = (Put)dataRowState.getSecond()) != null ? IndexRebuildRegionScanner.applyNew((Put)m, nextDataRowState) : new Put((Put)m)));
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
    }

    private void prepareDataRowStates(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, BatchMutateContext context, long now) throws IOException {
        if (context.rowsToLock.size() == 0) {
            return;
        }
        this.getCurrentRowStates(c, context);
        this.applyPendingPutMutations(miniBatchOp, context, now);
        this.applyPendingDeleteMutations(miniBatchOp, context);
    }

    public static void removeEmptyColumn(Mutation m, byte[] emptyCF, byte[] emptyCQ) {
        List cellList = (List)m.getFamilyCellMap().get(emptyCF);
        if (cellList == null) {
            return;
        }
        Iterator cellIterator = cellList.iterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            if (Bytes.compareTo((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])emptyCQ, (int)0, (int)emptyCQ.length) != 0) continue;
            cellIterator.remove();
            return;
        }
    }

    private void handleLocalIndexUpdates(TableName table, MiniBatchOperationInProgress<Mutation> miniBatchOp, Collection<? extends Mutation> pendingMutations, PhoenixIndexMetaData indexMetaData) throws Throwable {
        ArrayListMultimap indexUpdates = ArrayListMultimap.create();
        this.builder.getIndexUpdates((ListMultimap<HTableInterfaceReference, Pair<Mutation, byte[]>>)indexUpdates, miniBatchOp, pendingMutations, indexMetaData);
        byte[] tableName = table.getName();
        HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(tableName));
        List localIndexUpdates = indexUpdates.removeAll((Object)hTableInterfaceReference);
        if (localIndexUpdates == null || localIndexUpdates.isEmpty()) {
            return;
        }
        ArrayList<Object> localUpdates = new ArrayList<Object>();
        for (Pair next : localIndexUpdates) {
            localUpdates.add(next.getFirst());
        }
        if (!localUpdates.isEmpty()) {
            miniBatchOp.addOperationsFromCP(0, localUpdates.toArray(new Mutation[localUpdates.size()]));
        }
    }

    private void getCurrentRowStates(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        HashSet<KeyRange> keys = new HashSet<KeyRange>(context.rowsToLock.size());
        context.dataRowStates = new HashMap(context.rowsToLock.size());
        for (ImmutableBytesPtr rowKeyPtr : context.rowsToLock) {
            PendingRow pendingRow = this.pendingRows.get((Object)rowKeyPtr);
            if (pendingRow != null && pendingRow.getLastContext().getCurrentPhase() == BatchMutatePhase.PRE) {
                Put put;
                if (context.lastConcurrentBatchContext == null) {
                    context.lastConcurrentBatchContext = new HashMap();
                }
                context.lastConcurrentBatchContext.put(rowKeyPtr, pendingRow.getLastContext());
                if (context.maxPendingRowCount < pendingRow.getCount()) {
                    context.maxPendingRowCount = pendingRow.getCount();
                }
                if ((put = pendingRow.getLastContext().getNextDataRowState(rowKeyPtr)) == null) continue;
                context.dataRowStates.put(rowKeyPtr, new Pair((Object)put, (Object)new Put(put)));
                continue;
            }
            keys.add(PVarbinary.INSTANCE.getKeyRange(rowKeyPtr.get()));
        }
        if (keys.isEmpty()) {
            return;
        }
        Scan scan = new Scan();
        ScanRanges scanRanges = ScanRanges.createPointLookup(new ArrayList<KeyRange>(keys));
        scanRanges.initializeScan(scan);
        SkipScanFilter skipScanFilter = scanRanges.getSkipScanFilter();
        scan.setFilter((Filter)skipScanFilter);
        try (RegionScanner scanner = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getScanner(scan);){
            boolean more = true;
            while (more) {
                ArrayList cells = new ArrayList();
                more = scanner.next(cells);
                if (cells.isEmpty()) continue;
                byte[] rowKey = CellUtil.cloneRow((Cell)((Cell)cells.get(0)));
                Put put = new Put(rowKey);
                for (Cell cell : cells) {
                    put.add(cell);
                }
                context.dataRowStates.put(new ImmutableBytesPtr(rowKey), new Pair((Object)put, (Object)new Put(put)));
            }
        }
    }

    private void prepareIndexMutations(BatchMutateContext context, List<IndexMaintainer> maintainers, long ts) throws IOException {
        ArrayList<Pair> indexTables = new ArrayList<Pair>(maintainers.size());
        for (IndexMaintainer indexMaintainer : maintainers) {
            if (indexMaintainer.isLocalIndex()) continue;
            HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
            indexTables.add(new Pair((Object)indexMaintainer, (Object)hTableInterfaceReference));
        }
        for (Map.Entry entry : context.dataRowStates.entrySet()) {
            ImmutableBytesPtr rowKeyPtr = (ImmutableBytesPtr)((Object)entry.getKey());
            Pair dataRowState = (Pair)entry.getValue();
            Put currentDataRowState = (Put)dataRowState.getFirst();
            Put nextDataRowState = (Put)dataRowState.getSecond();
            if (currentDataRowState == null && nextDataRowState == null) continue;
            for (Pair pair : indexTables) {
                IndexMaintainer indexMaintainer = (IndexMaintainer)pair.getFirst();
                HTableInterfaceReference hTableInterfaceReference = (HTableInterfaceReference)pair.getSecond();
                if (nextDataRowState != null) {
                    GlobalIndexRegionScanner.SimpleValueGetter nextDataRowVG = new GlobalIndexRegionScanner.SimpleValueGetter(nextDataRowState);
                    Put indexPut = indexMaintainer.buildUpdateMutation(GenericKeyValueBuilder.INSTANCE, nextDataRowVG, rowKeyPtr, ts, null, null);
                    if (indexPut == null) {
                        byte[] indexRowKey = indexMaintainer.buildRowKey(nextDataRowVG, rowKeyPtr, null, null, Long.MAX_VALUE);
                        indexPut = new Put(indexRowKey);
                    } else {
                        IndexRegionObserver.removeEmptyColumn((Mutation)indexPut, indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier());
                    }
                    indexPut.addColumn(indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary(), indexMaintainer.getEmptyKeyValueQualifier(), ts, UNVERIFIED_BYTES);
                    context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)indexPut, (Object)rowKeyPtr.get()));
                    if (currentDataRowState == null) continue;
                    GlobalIndexRegionScanner.SimpleValueGetter currentDataRowVG = new GlobalIndexRegionScanner.SimpleValueGetter(currentDataRowState);
                    byte[] indexRowKeyForCurrentDataRow = indexMaintainer.buildRowKey(currentDataRowVG, rowKeyPtr, null, null, Long.MAX_VALUE);
                    if (Bytes.compareTo((byte[])indexPut.getRow(), (byte[])indexRowKeyForCurrentDataRow) == 0) continue;
                    Delete del = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                    context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)del, (Object)rowKeyPtr.get()));
                    continue;
                }
                if (currentDataRowState == null) continue;
                GlobalIndexRegionScanner.SimpleValueGetter currentDataRowVG = new GlobalIndexRegionScanner.SimpleValueGetter(currentDataRowState);
                byte[] indexRowKeyForCurrentDataRow = indexMaintainer.buildRowKey(currentDataRowVG, rowKeyPtr, null, null, Long.MAX_VALUE);
                Delete del = indexMaintainer.buildRowDeleteMutation(indexRowKeyForCurrentDataRow, IndexMaintainer.DeleteType.ALL_VERSIONS, ts);
                context.indexUpdates.put((Object)hTableInterfaceReference, (Object)new Pair((Object)del, (Object)rowKeyPtr.get()));
            }
        }
    }

    private void preparePreIndexMutations(BatchMutateContext context, long now, PhoenixIndexMetaData indexMetaData) throws Throwable {
        List<IndexMaintainer> maintainers = indexMetaData.getIndexMaintainers();
        try (TraceScope scope = Trace.startSpan((String)"Starting to build index updates");){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            current.addTimelineAnnotation("Built index updates, doing preStep");
            context.indexUpdates = (ListMultimap)ArrayListMultimap.create();
            this.prepareIndexMutations(context, maintainers, now);
            context.preIndexUpdates = (ListMultimap)ArrayListMultimap.create();
            int updateCount = 0;
            for (IndexMaintainer indexMaintainer : maintainers) {
                ++updateCount;
                byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
                byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
                HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
                List updates = context.indexUpdates.get((Object)hTableInterfaceReference);
                for (Pair update : updates) {
                    Mutation m = (Mutation)update.getFirst();
                    if (m instanceof Put) {
                        context.preIndexUpdates.put((Object)hTableInterfaceReference, (Object)m);
                        continue;
                    }
                    Put unverifiedPut = new Put(m.getRow());
                    unverifiedPut.addColumn(emptyCF, emptyCQ, now, UNVERIFIED_BYTES);
                    context.preIndexUpdates.put((Object)hTableInterfaceReference, (Object)unverifiedPut);
                }
            }
            TracingUtils.addAnnotation(current, "index update count", updateCount);
        }
    }

    protected PhoenixIndexMetaData getPhoenixIndexMetaData(ObserverContext<RegionCoprocessorEnvironment> observerContext, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        IndexMetaData indexMetaData = this.builder.getIndexMetaData(miniBatchOp);
        if (!(indexMetaData instanceof PhoenixIndexMetaData)) {
            throw new DoNotRetryIOException("preBatchMutateWithExceptions: indexMetaData is not an instance of " + PhoenixIndexMetaData.class.getName() + ", current table is:" + ((RegionCoprocessorEnvironment)observerContext.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString());
        }
        return (PhoenixIndexMetaData)indexMetaData;
    }

    private void preparePostIndexMutations(BatchMutateContext context, long now, PhoenixIndexMetaData indexMetaData) {
        context.postIndexUpdates = (ListMultimap)ArrayListMultimap.create();
        List<IndexMaintainer> maintainers = indexMetaData.getIndexMaintainers();
        for (IndexMaintainer indexMaintainer : maintainers) {
            byte[] emptyCF = indexMaintainer.getEmptyKeyValueFamily().copyBytesIfNecessary();
            byte[] emptyCQ = indexMaintainer.getEmptyKeyValueQualifier();
            HTableInterfaceReference hTableInterfaceReference = new HTableInterfaceReference(new ImmutableBytesPtr(indexMaintainer.getIndexTableName()));
            List updates = context.indexUpdates.get((Object)hTableInterfaceReference);
            for (Pair update : updates) {
                Mutation m = (Mutation)update.getFirst();
                if (m instanceof Put) {
                    Put verifiedPut = new Put(m.getRow());
                    verifiedPut.addColumn(emptyCF, emptyCQ, now, VERIFIED_BYTES);
                    context.postIndexUpdates.put((Object)hTableInterfaceReference, (Object)verifiedPut);
                    continue;
                }
                context.postIndexUpdates.put((Object)hTableInterfaceReference, (Object)m);
            }
        }
        this.removePendingRows(context);
        context.indexUpdates.clear();
    }

    private static boolean hasGlobalIndex(PhoenixIndexMetaData indexMetaData) {
        for (IndexMaintainer indexMaintainer : indexMetaData.getIndexMaintainers()) {
            if (indexMaintainer.isLocalIndex()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLocalIndex(PhoenixIndexMetaData indexMetaData) {
        for (IndexMaintainer indexMaintainer : indexMetaData.getIndexMaintainers()) {
            if (!indexMaintainer.isLocalIndex()) continue;
            return true;
        }
        return false;
    }

    private void waitForPreviousConcurrentBatch(TableName table, BatchMutateContext context) throws Throwable {
        boolean done = true;
        for (BatchMutateContext lastContext : context.lastConcurrentBatchContext.values()) {
            BatchMutatePhase phase = lastContext.getCurrentPhase();
            if (phase == BatchMutatePhase.FAILED) {
                done = false;
                break;
            }
            if (phase != BatchMutatePhase.PRE) continue;
            CountDownLatch countDownLatch = lastContext.getCountDownLatch();
            this.unlockRows(context);
            if (!countDownLatch.await((lastContext.getMaxPendingRowCount() + 1) * this.concurrentMutationWaitDuration, TimeUnit.MILLISECONDS)) {
                done = false;
                break;
            }
            this.lockRows(context);
        }
        if (!done) {
            this.removePendingRows(context);
            context.indexUpdates.clear();
            for (LockManager.RowLock rowLock : context.rowLocks) {
                rowLock.release();
            }
            context.rowLocks.clear();
            throw new IOException("One of the previous concurrent mutations has not completed. The batch needs to be retried " + table.getNameAsString());
        }
    }

    public void preBatchMutateWithExceptions(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws Throwable {
        this.ignoreAtomicOperations(miniBatchOp);
        PhoenixIndexMetaData indexMetaData = this.getPhoenixIndexMetaData(c, miniBatchOp);
        BatchMutateContext context = new BatchMutateContext(indexMetaData.getClientVersion());
        this.setBatchMutateContext(c, context);
        context.populateOriginalMutations(miniBatchOp);
        this.setDeleteAttributes(miniBatchOp);
        this.populateRowsToLock(miniBatchOp, context);
        if (context.rowsToLock.isEmpty()) {
            return;
        }
        this.lockRows(context);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        IndexRegionObserver.setTimestamps(miniBatchOp, this.builder, now);
        TableName table = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable();
        if (IndexRegionObserver.hasGlobalIndex(indexMetaData)) {
            this.prepareDataRowStates(c, miniBatchOp, context, now);
            this.populatePendingRows(context);
            long start = EnvironmentEdgeManager.currentTimeMillis();
            this.preparePreIndexMutations(context, now, indexMetaData);
            this.metricSource.updateIndexPrepareTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            if (!context.rowLocks.isEmpty() && now == EnvironmentEdgeManager.currentTimeMillis()) {
                Thread.sleep(1L);
                LOG.debug("slept 1ms for " + table.getNameAsString());
            }
            this.unlockRows(context);
            this.doPre(c, context, miniBatchOp);
            this.lockRows(context);
            if (context.lastConcurrentBatchContext != null) {
                this.waitForPreviousConcurrentBatch(table, context);
            }
            this.preparePostIndexMutations(context, now, indexMetaData);
        }
        if (IndexRegionObserver.hasLocalIndex(indexMetaData)) {
            Collection<? extends Mutation> mutations = this.groupMutations(miniBatchOp, context);
            this.handleLocalIndexUpdates(table, miniBatchOp, mutations, indexMetaData);
        }
        if (failDataTableUpdatesForTesting) {
            throw new DoNotRetryIOException("Simulating the data table write failure");
        }
    }

    private void setDeleteAttributes(MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        for (int i = 0; i < miniBatchOp.size(); ++i) {
            byte[] sourceOpAttr;
            Mutation m = (Mutation)miniBatchOp.getOperation(i);
            if (!(m instanceof Delete) || (sourceOpAttr = m.getAttribute("phoenix.source.operation")) == null) continue;
            Tag sourceOpTag = new Tag(65, sourceOpAttr);
            ArrayList<TagRewriteCell> updatedCells = new ArrayList<TagRewriteCell>();
            CellScanner cellScanner = m.cellScanner();
            while (cellScanner.advance()) {
                Cell cell = cellScanner.current();
                List tags = Tag.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
                tags.add(sourceOpTag);
                TagRewriteCell updatedCell = new TagRewriteCell(cell, Tag.fromList((List)tags));
                updatedCells.add(updatedCell);
            }
            m.getFamilyCellMap().clear();
            for (Cell cell : updatedCells) {
                Delete d = (Delete)m;
                d.addDeleteMarker(cell);
            }
        }
    }

    private void setBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) {
        this.batchMutateContext.set(context);
    }

    private BatchMutateContext getBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        return this.batchMutateContext.get();
    }

    private void removeBatchMutateContext(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.batchMutateContext.remove();
    }

    public void preWALAppend(ObserverContext<RegionCoprocessorEnvironment> c, WALKey key, WALEdit edit) {
        if (HbaseCompatCapabilities.hasPreWALAppend() && this.shouldWALAppend) {
            BatchMutateContext context = this.getBatchMutateContext(c);
            WALAnnotationUtil.appendMutationAttributesToWALKey(key, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (this.disabled) {
            return;
        }
        BatchMutateContext context = this.getBatchMutateContext(c);
        if (context == null) {
            return;
        }
        try {
            if (success) {
                context.currentPhase = BatchMutatePhase.POST;
            } else {
                context.currentPhase = BatchMutatePhase.FAILED;
            }
            if (context.waitList != null) {
                for (CountDownLatch countDownLatch : context.waitList) {
                    countDownLatch.countDown();
                }
            }
            this.unlockRows(context);
            this.builder.batchCompleted(miniBatchOp);
            if (success) {
                this.doPost(c, context);
            }
        }
        finally {
            this.removeBatchMutateContext(c);
        }
    }

    private void doPost(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            if (failPostIndexUpdatesForTesting) {
                throw new DoNotRetryIOException("Simulating the last (i.e., post) index table write failure");
            }
            this.doIndexWritesWithExceptions(context, true);
            this.metricSource.updatePostIndexUpdateTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            return;
        }
        catch (Throwable e) {
            this.metricSource.updatePostIndexUpdateFailureTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            this.metricSource.incrementPostIndexUpdateFailures(this.dataTableName);
            return;
        }
    }

    private void doIndexWritesWithExceptions(BatchMutateContext context, boolean post) throws IOException {
        ListMultimap indexUpdates;
        ListMultimap listMultimap = indexUpdates = post ? context.postIndexUpdates : context.preIndexUpdates;
        if (context == null || indexUpdates == null || indexUpdates.isEmpty()) {
            return;
        }
        try (TraceScope scope = Trace.startSpan((String)("Completing " + (post ? "post" : "pre") + " index writes"));){
            Span current = scope.getSpan();
            if (current == null) {
                current = NullSpan.INSTANCE;
            }
            current.addTimelineAnnotation("Actually doing " + (post ? "post" : "pre") + " index update for first time");
            if (post) {
                this.postWriter.write((Multimap<HTableInterfaceReference, Mutation>)indexUpdates, false, context.clientVersion);
            } else {
                this.preWriter.write((Multimap<HTableInterfaceReference, Mutation>)indexUpdates, false, context.clientVersion);
            }
        }
    }

    private void removePendingRows(BatchMutateContext context) {
        for (LockManager.RowLock rowLock : context.rowLocks) {
            ImmutableBytesPtr rowKey = rowLock.getRowKey();
            PendingRow pendingRow = this.pendingRows.get((Object)rowKey);
            if (pendingRow == null) continue;
            pendingRow.remove();
            if (pendingRow.getCount() != 0) continue;
            this.pendingRows.remove((Object)rowKey);
        }
    }

    private void doPre(ObserverContext<RegionCoprocessorEnvironment> c, BatchMutateContext context, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        long start = EnvironmentEdgeManager.currentTimeMillis();
        try {
            if (failPreIndexUpdatesForTesting) {
                throw new DoNotRetryIOException("Simulating the first (i.e., pre) index table write failure");
            }
            this.doIndexWritesWithExceptions(context, false);
            this.metricSource.updatePreIndexUpdateTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            return;
        }
        catch (Throwable e) {
            this.metricSource.updatePreIndexUpdateFailureTime(this.dataTableName, EnvironmentEdgeManager.currentTimeMillis() - start);
            this.metricSource.incrementPreIndexUpdateFailures(this.dataTableName);
            this.removePendingRows(context);
            context.rowLocks.clear();
            IndexManagementUtil.rethrowIndexingException(e);
            throw new RuntimeException("Somehow didn't complete the index update, but didn't return succesfully either!");
        }
    }

    public static void enableIndexing(HTableDescriptor desc, Class<? extends IndexBuilder> builder, Map<String, String> properties, int priority) throws IOException {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        properties.put(INDEX_BUILDER_CONF_KEY, builder.getName());
        desc.addCoprocessor(IndexRegionObserver.class.getName(), null, priority, properties);
    }

    public static class BatchMutateContext {
        private BatchMutatePhase currentPhase = BatchMutatePhase.PRE;
        private int maxPendingRowCount = 0;
        private final int clientVersion;
        private ListMultimap<HTableInterfaceReference, Mutation> preIndexUpdates;
        private ListMultimap<HTableInterfaceReference, Mutation> postIndexUpdates;
        private ListMultimap<HTableInterfaceReference, Pair<Mutation, byte[]>> indexUpdates;
        private List<LockManager.RowLock> rowLocks = Lists.newArrayListWithExpectedSize((int)100);
        private HashSet<ImmutableBytesPtr> rowsToLock = new HashSet();
        private HashMap<ImmutableBytesPtr, Pair<Put, Put>> dataRowStates;
        private HashMap<ImmutableBytesPtr, BatchMutateContext> lastConcurrentBatchContext = null;
        private List<CountDownLatch> waitList = null;
        private Map<ImmutableBytesPtr, MultiMutation> multiMutationMap;
        private List<Mutation> originalMutations;

        public BatchMutateContext() {
            this.clientVersion = 0;
        }

        public BatchMutateContext(int clientVersion) {
            this.clientVersion = clientVersion;
        }

        public void populateOriginalMutations(MiniBatchOperationInProgress<Mutation> miniBatchOp) {
            this.originalMutations = new ArrayList<Mutation>(miniBatchOp.size());
            for (int k = 0; k < miniBatchOp.size(); ++k) {
                this.originalMutations.add((Mutation)miniBatchOp.getOperation(k));
            }
        }

        public List<Mutation> getOriginalMutations() {
            return this.originalMutations;
        }

        public BatchMutatePhase getCurrentPhase() {
            return this.currentPhase;
        }

        public Put getNextDataRowState(ImmutableBytesPtr rowKeyPtr) {
            Pair<Put, Put> rowState = this.dataRowStates.get((Object)rowKeyPtr);
            if (rowState != null) {
                return (Put)rowState.getSecond();
            }
            return null;
        }

        public CountDownLatch getCountDownLatch() {
            if (this.waitList == null) {
                this.waitList = new ArrayList<CountDownLatch>();
            }
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.waitList.add(countDownLatch);
            return countDownLatch;
        }

        public int getMaxPendingRowCount() {
            return this.maxPendingRowCount;
        }
    }

    public static enum BatchMutatePhase {
        PRE,
        POST,
        FAILED;

    }

    private static class PendingRow {
        private int count = 1;
        private BatchMutateContext lastContext;

        PendingRow(BatchMutateContext context) {
            this.lastContext = context;
        }

        public void add(BatchMutateContext context) {
            ++this.count;
            this.lastContext = context;
        }

        public void remove() {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }

        public BatchMutateContext getLastContext() {
            return this.lastContext;
        }
    }
}

