/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Abortable;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskBatch<V>
implements Abortable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBatch.class);
    private AtomicBoolean aborted = new AtomicBoolean();
    private List<Task<V>> tasks;

    public TaskBatch(int size) {
        this.tasks = new ArrayList<Task<V>>(size);
    }

    public void add(Task<V> task) {
        this.tasks.add(task);
        task.setBatchMonitor(this);
    }

    public Collection<Task<V>> getTasks() {
        return this.tasks;
    }

    public void abort(String why, Throwable e) {
        if (this.aborted.getAndSet(true)) {
            return;
        }
        LOGGER.info("Aborting batch of tasks because " + why);
    }

    public boolean isAborted() {
        return this.aborted.get();
    }

    public int size() {
        return this.tasks.size();
    }
}

