/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.write.IndexFailurePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillServerOnFailurePolicy
implements IndexFailurePolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(KillServerOnFailurePolicy.class);
    private Abortable abortable;
    private Stoppable stoppable;

    @Override
    public void setup(Stoppable parent, RegionCoprocessorEnvironment env) {
        this.setup(parent, (Abortable)env.getRegionServerServices());
    }

    public void setup(Stoppable parent, Abortable abort) {
        this.stoppable = parent;
        this.abortable = abort;
    }

    public void stop(String why) {
    }

    public boolean isStopped() {
        return this.stoppable.isStopped();
    }

    @Override
    public void handleFailure(Multimap<HTableInterfaceReference, Mutation> attempted, Exception cause) throws IOException {
        this.stop("Killing ourselves because of an error:" + cause);
        String msg = "Could not update the index table, killing server region because couldn't write to an index table";
        LOGGER.error(msg, (Throwable)cause);
        try {
            this.abortable.abort(msg, (Throwable)cause);
        }
        catch (Exception e) {
            LOGGER.error("Couldn't abort this server to preserve index writes, attempting to hard kill the server");
            System.exit(1);
        }
    }
}

