/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.schema.tuple.Tuple;

public class LimitingResultIterator
extends DelegateResultIterator {
    private int rowCount;
    private final int limit;

    public LimitingResultIterator(ResultIterator delegate, int limit) {
        super(delegate);
        this.limit = limit;
    }

    @Override
    public Tuple next() throws SQLException {
        if (this.rowCount++ >= this.limit) {
            this.close();
            return null;
        }
        return super.next();
    }

    @Override
    public void explain(List<String> planSteps) {
        super.explain(planSteps);
        planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
    }

    @Override
    public void explain(List<String> planSteps, ExplainPlanAttributes.ExplainPlanAttributesBuilder explainPlanAttributesBuilder) {
        super.explain(planSteps, explainPlanAttributesBuilder);
        explainPlanAttributesBuilder.setClientRowLimit(this.limit);
        planSteps.add("CLIENT " + this.limit + " ROW LIMIT");
    }

    public String toString() {
        return "LimitingResultIterator [rowCount=" + this.rowCount + ", limit=" + this.limit + "]";
    }
}

