/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PDecimal;

public class PhoenixResultSetMetaData
implements ResultSetMetaData {
    static final int DEFAULT_DISPLAY_WIDTH = 40;
    private final RowProjector rowProjector;
    private final PhoenixConnection connection;

    public PhoenixResultSetMetaData(PhoenixConnection connection, RowProjector projector) {
        this.connection = connection;
        this.rowProjector = projector;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        PDataType type = this.rowProjector.getColumnProjector(column - 1).getExpression().getDataType();
        return type == null ? null : type.getJavaClassName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.rowProjector.getColumnCount();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        ColumnProjector projector = this.rowProjector.getColumnProjector(column - 1);
        PDataType type = projector.getExpression().getDataType();
        if (type == null) {
            return "<null>".length();
        }
        if (type.isCoercibleTo(PDate.INSTANCE)) {
            return this.connection.getDatePattern().length();
        }
        if (projector.getExpression().getMaxLength() != null) {
            return projector.getExpression().getMaxLength();
        }
        return 40;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.rowProjector.getColumnProjector(column - 1).getName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.rowProjector.getColumnProjector(column - 1).getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        PDataType type = this.rowProjector.getColumnProjector(column - 1).getExpression().getDataType();
        return type == null ? 0 : type.getResultSetSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        PDataType type = this.rowProjector.getColumnProjector(column - 1).getExpression().getDataType();
        return type == null ? null : type.getSqlTypeName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Integer precision = this.rowProjector.getColumnProjector(column - 1).getExpression().getMaxLength();
        return precision == null ? 0 : precision;
    }

    @Override
    public int getScale(int column) throws SQLException {
        Integer scale = this.rowProjector.getColumnProjector(column - 1).getExpression().getScale();
        return scale == null ? 0 : scale;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.rowProjector.getColumnProjector(column - 1).getTableName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.rowProjector.getColumnProjector(column - 1).isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.rowProjector.getColumnProjector(column - 1).getExpression().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        PDataType type = this.rowProjector.getColumnProjector(column - 1).getExpression().getDataType();
        if (type == null) {
            return false;
        }
        return type.isCoercibleTo(PDecimal.INSTANCE);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isInstance(this)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CLASS_NOT_UNWRAPPABLE).setMessage(this.getClass().getName() + " not unwrappable from " + iface.getName()).build().buildException();
        }
        return (T)this;
    }
}

