/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.index;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectHTableWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectHTableWriter.class);
    private Configuration conf = null;
    private HTable table;

    public DirectHTableWriter(Configuration otherConf) {
        this.setConf(otherConf);
    }

    protected void setConf(Configuration otherConf) {
        this.conf = HBaseConfiguration.create((Configuration)otherConf);
        String tableName = this.conf.get("hbase.mapred.outputtable");
        if (tableName == null || tableName.length() <= 0) {
            throw new IllegalArgumentException("Must specify table name");
        }
        try {
            this.table = new HTable(this.conf, tableName);
            this.table.setAutoFlush(false, true);
            LOGGER.info("Created table instance for " + tableName);
        }
        catch (IOException e) {
            LOGGER.error("IOException : ", (Throwable)e);
            this.tryClosingResourceSilently((Closeable)this.table);
            throw new RuntimeException(e);
        }
    }

    public void write(List<Mutation> mutations) throws IOException, InterruptedException {
        Object[] results = new Object[mutations.size()];
        String txnIdStr = this.conf.get("phoenix.mr.txscn.value");
        if (txnIdStr == null) {
            this.table.batch(mutations, results);
        } else {
            long ts = Long.parseLong(txnIdStr);
            PhoenixTransactionProvider provider = TransactionFactory.Provider.getDefault().getTransactionProvider();
            String txnProviderStr = this.conf.get("phoenix.mr.txprovider");
            if (txnProviderStr != null) {
                provider = TransactionFactory.Provider.valueOf(txnProviderStr).getTransactionProvider();
            }
            ArrayList shadowedMutations = Lists.newArrayListWithExpectedSize((int)mutations.size());
            for (Mutation m : mutations) {
                if (!(m instanceof Put)) continue;
                shadowedMutations.add(provider.markPutAsCommitted((Put)m, ts, ts));
            }
            this.table.batch((List)shadowedMutations, results);
        }
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected HTable getTable() {
        return this.table;
    }

    private void tryClosingResourceSilently(Closeable res) {
        if (res != null) {
            try {
                res.close();
            }
            catch (IOException e) {
                LOGGER.error("Closing resource: " + res + " failed with error: ", (Throwable)e);
            }
        }
    }

    public void close() throws IOException {
        this.tryClosingResourceSilently((Closeable)this.table);
    }
}

