/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.util.SchemaUtil;

public abstract class ConcreteTableNode
extends TableNode {
    public static final Double DEFAULT_TABLE_SAMPLING_RATE = null;
    private final TableName name;
    private final Double tableSamplingRate;

    ConcreteTableNode(String alias, TableName name) {
        this(alias, name, DEFAULT_TABLE_SAMPLING_RATE);
    }

    ConcreteTableNode(String alias, TableName name, Double tableSamplingRate) {
        super(SchemaUtil.normalizeIdentifier(alias));
        this.name = name;
        if (tableSamplingRate == null) {
            this.tableSamplingRate = DEFAULT_TABLE_SAMPLING_RATE;
        } else {
            if (tableSamplingRate < 0.0 || tableSamplingRate > 100.0) {
                throw new IllegalArgumentException("TableSamplingRate is out of bound of 0 and 100");
            }
            this.tableSamplingRate = tableSamplingRate;
        }
    }

    public TableName getName() {
        return this.name;
    }

    public Double getTableSamplingRate() {
        return this.tableSamplingRate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tableSamplingRate == null ? 0 : this.tableSamplingRate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConcreteTableNode other = (ConcreteTableNode)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tableSamplingRate == null ? other.tableSamplingRate != null : !this.tableSamplingRate.equals(other.tableSamplingRate));
    }
}

