/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.parse;

import java.sql.SQLException;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TerminalParseNode;

public class SequenceValueParseNode
extends TerminalParseNode {
    private final TableName tableName;
    private final Op op;
    private final ParseNode numToAllocate;

    public SequenceValueParseNode(TableName tableName, Op op, ParseNode numToAllocate) {
        this.tableName = tableName;
        this.op = op;
        this.numToAllocate = numToAllocate;
    }

    public ParseNode getNumToAllocateNode() {
        return this.numToAllocate;
    }

    @Override
    public <T> T accept(ParseNodeVisitor<T> visitor) throws SQLException {
        return visitor.visit(this);
    }

    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    public Op getOp() {
        return this.op;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SequenceValueParseNode other = (SequenceValueParseNode)obj;
        if (this.op != other.op) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    @Override
    public void toSQL(ColumnResolver resolver, StringBuilder buf) {
        buf.append(' ');
        buf.append(this.op.getName());
        buf.append(" VALUE FOR ");
        buf.append(this.tableName);
    }

    public static enum Op {
        NEXT_VALUE("NEXT"),
        CURRENT_VALUE("CURRENT");

        private final String name;

        private Op(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

