/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTinyint;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PTinyintArray
extends PArrayDataType<byte[]> {
    public static final PTinyintArray INSTANCE = new PTinyintArray();

    private PTinyintArray() {
        super("TINYINT ARRAY", 3000 + PTinyint.INSTANCE.getSqlType(), PhoenixArray.class, null, 32);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PTinyint.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PTinyint.INSTANCE, sortOrder, maxLength, scale, PTinyint.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        byte[] byteArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveBytePhoenixArray pArr = (PhoenixArray.PrimitiveBytePhoenixArray)value;
        for (byte i : byteArr = (byte[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PTinyint.INSTANCE, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PTinyint.INSTANCE, arrayLength, maxLength);
    }
}

