/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.EnvironmentEdgeManager;

public class TransactionUtil {
    public static final byte[] FAMILY_DELETE_MARKER = HConstants.EMPTY_BYTE_ARRAY;
    public static final int MAX_TRANSACTIONS_PER_MILLISECOND = 1000000;
    private static final long MAX_NON_TX_TIMESTAMP = (long)((double)EnvironmentEdgeManager.currentTimeMillis() * 1.1);

    private TransactionUtil() {
    }

    public static boolean isTransactionalTimestamp(long ts) {
        return ts >= MAX_NON_TX_TIMESTAMP && ts != Long.MAX_VALUE;
    }

    public static boolean isDelete(Cell cell) {
        return CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    public static boolean isDeleteFamily(Cell cell) {
        return CellUtil.matchingQualifier((Cell)cell, (byte[])FAMILY_DELETE_MARKER) && CellUtil.matchingValue((Cell)cell, (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    private static Cell newDeleteFamilyMarker(byte[] row, byte[] family, long timestamp) {
        return CellUtil.createCell((byte[])row, (byte[])family, (byte[])FAMILY_DELETE_MARKER, (long)timestamp, (byte)KeyValue.Type.Put.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    private static Cell newDeleteColumnMarker(byte[] row, byte[] family, byte[] qualifier, long timestamp) {
        return CellUtil.createCell((byte[])row, (byte[])family, (byte[])qualifier, (long)timestamp, (byte)KeyValue.Type.Put.getCode(), (byte[])HConstants.EMPTY_BYTE_ARRAY);
    }

    public static long convertToNanoseconds(long serverTimeStamp) {
        return serverTimeStamp * 1000000L;
    }

    public static long convertToMilliseconds(long serverTimeStamp) {
        return serverTimeStamp / 1000000L;
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, boolean isTransactional, long defaultResolvedTimestamp) {
        MutationState mutationState = connection.getMutationState();
        Long scn = connection.getSCN();
        return scn != null ? scn : (isTransactional && mutationState.isTransactionStarted() ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : defaultResolvedTimestamp);
    }

    public static long getResolvedTime(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        boolean isTransactional = table != null && table.isTransactional();
        return TransactionUtil.getResolvedTimestamp(connection, isTransactional, result.getMutationTime());
    }

    public static long getResolvedTimestamp(PhoenixConnection connection, MetaDataProtocol.MetaDataMutationResult result) {
        PTable table = result.getTable();
        MutationState mutationState = connection.getMutationState();
        boolean txInProgress = table != null && table.isTransactional() && mutationState.isTransactionStarted();
        return txInProgress ? TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer()) : result.getMutationTime();
    }

    public static Long getTableTimestamp(PhoenixConnection connection, boolean transactional, TransactionFactory.Provider provider) throws SQLException {
        Long timestamp = null;
        if (!transactional) {
            return timestamp;
        }
        MutationState mutationState = connection.getMutationState();
        if (!mutationState.isTransactionStarted()) {
            mutationState.startTransaction(provider);
        }
        timestamp = TransactionUtil.convertToMilliseconds(mutationState.getInitialWritePointer());
        return timestamp;
    }

    public static Mutation convertIfDelete(Mutation mutation) throws IOException {
        if (mutation instanceof Delete) {
            Put deleteMarker = null;
            for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
                byte[] family = (byte[])entry.getKey();
                List familyCells = (List)entry.getValue();
                if (familyCells.size() == 1) {
                    if (!CellUtil.isDeleteFamily((Cell)((Cell)familyCells.get(0)))) continue;
                    if (deleteMarker == null) {
                        deleteMarker = new Put(mutation.getRow());
                    }
                    deleteMarker.add(TransactionUtil.newDeleteFamilyMarker(deleteMarker.getRow(), family, ((Cell)familyCells.get(0)).getTimestamp()));
                    continue;
                }
                for (Cell cell : familyCells) {
                    if (!CellUtil.isDeleteColumns((Cell)cell)) continue;
                    if (deleteMarker == null) {
                        deleteMarker = new Put(mutation.getRow());
                    }
                    deleteMarker.add(TransactionUtil.newDeleteColumnMarker(deleteMarker.getRow(), family, CellUtil.cloneQualifier((Cell)cell), cell.getTimestamp()));
                }
            }
            if (deleteMarker != null) {
                for (Map.Entry entry : mutation.getAttributesMap().entrySet()) {
                    deleteMarker.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
                }
                mutation = deleteMarker;
            }
        }
        return mutation;
    }
}

