/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.charset;

import com.ibm.icu.charset.CharsetMBCS;
import com.ibm.icu.charset.UConverterStaticData;
import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.InvalidFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

final class UConverterDataReader {
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private int posAfterStaticData;
    private ByteBuffer byteBuffer;
    private static final int DATA_FORMAT_ID = 1668183668;

    protected UConverterDataReader(ByteBuffer bytes) throws IOException {
        this.byteBuffer = bytes;
        ICUBinary.readHeader(this.byteBuffer, 1668183668, IS_ACCEPTABLE);
    }

    protected void readStaticData(UConverterStaticData sd) throws IOException {
        sd.structSize = this.byteBuffer.getInt();
        byte[] name = new byte[60];
        this.byteBuffer.get(name);
        sd.name = new String(name, "US-ASCII");
        sd.codepage = this.byteBuffer.getInt();
        sd.platform = this.byteBuffer.get();
        sd.conversionType = this.byteBuffer.get();
        sd.minBytesPerChar = this.byteBuffer.get();
        sd.maxBytesPerChar = this.byteBuffer.get();
        this.byteBuffer.get(sd.subChar);
        sd.subCharLen = this.byteBuffer.get();
        sd.hasToUnicodeFallback = this.byteBuffer.get();
        sd.hasFromUnicodeFallback = this.byteBuffer.get();
        sd.unicodeMask = (short)(this.byteBuffer.get() & 0xFF);
        sd.subChar1 = this.byteBuffer.get();
        this.byteBuffer.get(sd.reserved);
        this.posAfterStaticData = this.byteBuffer.position();
    }

    int bytesReadAfterStaticData() {
        return this.byteBuffer.position() - this.posAfterStaticData;
    }

    protected void readMBCSHeader(CharsetMBCS.MBCSHeader h) throws IOException {
        this.byteBuffer.get(h.version);
        h.countStates = this.byteBuffer.getInt();
        h.countToUFallbacks = this.byteBuffer.getInt();
        h.offsetToUCodeUnits = this.byteBuffer.getInt();
        h.offsetFromUTable = this.byteBuffer.getInt();
        h.offsetFromUBytes = this.byteBuffer.getInt();
        h.flags = this.byteBuffer.getInt();
        h.fromUBytesLength = this.byteBuffer.getInt();
        if (h.version[0] == 5 && h.version[1] >= 3) {
            h.options = this.byteBuffer.getInt();
            if ((h.options & 0x40) != 0) {
                h.fullStage2Length = this.byteBuffer.getInt();
            }
        }
    }

    protected void readMBCSTable(CharsetMBCS.MBCSHeader header, CharsetMBCS.UConverterMBCSTable mbcsTable) throws IOException {
        block13: {
            block12: {
                boolean noFromU;
                int i;
                IntBuffer intBuffer = this.byteBuffer.asIntBuffer();
                mbcsTable.countStates = (byte)header.countStates;
                mbcsTable.stateTable = new int[header.countStates][256];
                for (i = 0; i < header.countStates; ++i) {
                    intBuffer.get(mbcsTable.stateTable[i]);
                }
                mbcsTable.countToUFallbacks = header.countToUFallbacks;
                mbcsTable.toUFallbacks = new CharsetMBCS.MBCSToUFallback[header.countToUFallbacks];
                for (i = 0; i < header.countToUFallbacks; ++i) {
                    int offset = intBuffer.get();
                    int codePoint = intBuffer.get();
                    mbcsTable.toUFallbacks[i] = new CharsetMBCS.MBCSToUFallback(offset, codePoint);
                }
                int length = intBuffer.position() * 4;
                ICUBinary.skipBytes(this.byteBuffer, length);
                CharBuffer charBuffer = this.byteBuffer.asCharBuffer();
                length = header.offsetFromUTable - header.offsetToUCodeUnits;
                assert ((length & 1) == 0);
                mbcsTable.unicodeCodeUnits = new char[length / 2];
                charBuffer.get(mbcsTable.unicodeCodeUnits);
                ICUBinary.skipBytes(this.byteBuffer, length);
                length = header.offsetFromUBytes - header.offsetFromUTable;
                assert ((length & 1) == 0);
                int fromUTableCharsLength = mbcsTable.outputType == 0 ? length / 2 : (mbcsTable.hasSupplementary() ? 1088 : 64);
                mbcsTable.fromUnicodeTable = new char[fromUTableCharsLength];
                charBuffer.get(mbcsTable.fromUnicodeTable);
                if (mbcsTable.outputType != 0) {
                    assert ((length & 3) == 0);
                    mbcsTable.fromUnicodeTableInts = new int[length / 4];
                    this.byteBuffer.asIntBuffer().get(mbcsTable.fromUnicodeTableInts);
                }
                ICUBinary.skipBytes(this.byteBuffer, length);
                mbcsTable.fromUBytesLength = header.fromUBytesLength;
                boolean bl = noFromU = (header.options & 0x40) != 0;
                if (noFromU) break block12;
                switch (mbcsTable.outputType) {
                    case 0: 
                    case 1: 
                    case 8: 
                    case 12: {
                        mbcsTable.fromUnicodeChars = ICUBinary.getChars(this.byteBuffer, header.fromUBytesLength / 2, 0);
                        break block13;
                    }
                    case 2: 
                    case 9: {
                        mbcsTable.fromUnicodeBytes = new byte[header.fromUBytesLength];
                        this.byteBuffer.get(mbcsTable.fromUnicodeBytes);
                        break block13;
                    }
                    case 3: {
                        mbcsTable.fromUnicodeInts = ICUBinary.getInts(this.byteBuffer, header.fromUBytesLength / 4, 0);
                        break block13;
                    }
                    default: {
                        assert (false);
                        break block13;
                    }
                }
            }
            mbcsTable.mbcsIndex = this.byteBuffer.asCharBuffer();
        }
    }

    protected String readBaseTableName() throws IOException {
        char c;
        StringBuilder name = new StringBuilder();
        while ((c = (char)this.byteBuffer.get()) != '\u0000') {
            name.append(c);
        }
        return name.toString();
    }

    protected ByteBuffer readExtIndexes(int skip) throws IOException, InvalidFormatException {
        ICUBinary.skipBytes(this.byteBuffer, skip);
        ByteBuffer b = ICUBinary.sliceWithOrder(this.byteBuffer);
        int lengthOfIndexes = b.getInt(0);
        if (lengthOfIndexes < 32) {
            throw new InvalidFormatException();
        }
        int numBytesExtensionStructure = b.getInt(124);
        b.limit(numBytesExtensionStructure);
        ICUBinary.skipBytes(this.byteBuffer, numBytesExtensionStructure);
        return b;
    }

    boolean dataFormatHasUnicodeMask() {
        int formatVersion0 = this.byteBuffer.get(16) & 0xFF;
        return formatVersion0 > 6 || formatVersion0 == 6 && this.byteBuffer.get(17) != 0;
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] formatVersion) {
            return formatVersion[0] == 6;
        }
    }
}

