/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tso;

import com.google.protobuf.MessageLite;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.omid.metrics.MetricsRegistry;
import org.apache.omid.proto.TSOProto;
import org.apache.omid.tso.MonitoringContextFactory;
import org.apache.omid.tso.RequestProcessor;
import org.apache.omid.tso.TSOServerConfig;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.jboss.netty.handler.codec.frame.LengthFieldPrepender;
import org.jboss.netty.handler.codec.protobuf.ProtobufDecoder;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSOChannelHandler
extends SimpleChannelHandler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TSOChannelHandler.class);
    private final ChannelFactory factory;
    private final ServerBootstrap bootstrap;
    @VisibleForTesting
    Channel listeningChannel;
    @VisibleForTesting
    ChannelGroup channelGroup;
    private RequestProcessor requestProcessor;
    private TSOServerConfig config;
    private MetricsRegistry metrics;

    @Inject
    public TSOChannelHandler(TSOServerConfig config, RequestProcessor requestProcessor, MetricsRegistry metrics) {
        this.config = config;
        this.metrics = metrics;
        this.requestProcessor = requestProcessor;
        this.factory = new NioServerSocketChannelFactory(Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("boss-%d").build()), Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("worker-%d").build()), (Runtime.getRuntime().availableProcessors() * 2 + 1) * 2);
        this.bootstrap = new ServerBootstrap(this.factory);
        this.bootstrap.setPipelineFactory(new TSOPipelineFactory(this));
    }

    void reconnect() {
        if (this.listeningChannel == null && this.channelGroup == null) {
            LOG.debug("Creating communication channel...");
        } else {
            LOG.debug("Reconnecting communication channel...");
            this.closeConnection();
        }
        this.channelGroup = new DefaultChannelGroup(TSOChannelHandler.class.getName());
        LOG.debug("\tCreating channel to listening for incoming connections in port {}", (Object)this.config.getPort());
        this.listeningChannel = this.bootstrap.bind(new InetSocketAddress(this.config.getPort()));
        this.channelGroup.add(this.listeningChannel);
        LOG.debug("\tListening channel created and connected: {}", (Object)this.listeningChannel);
    }

    void closeConnection() {
        LOG.debug("Closing communication channel...");
        if (this.listeningChannel != null) {
            LOG.debug("\tUnbinding listening channel {}", (Object)this.listeningChannel);
            this.listeningChannel.unbind().awaitUninterruptibly();
            LOG.debug("\tListening channel {} unbound", (Object)this.listeningChannel);
        }
        if (this.channelGroup != null) {
            LOG.debug("\tClosing channel group {}", (Object)this.channelGroup);
            this.channelGroup.close().awaitUninterruptibly();
            LOG.debug("\tChannel group {} closed", (Object)this.channelGroup);
        }
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channelGroup.add(ctx.getChannel());
        LOG.debug("TSO channel connected: {}", (Object)ctx.getChannel());
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channelGroup.remove(ctx.getChannel());
        LOG.debug("TSO channel disconnected: {}", (Object)ctx.getChannel());
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        LOG.debug("TSO channel closed: {}", (Object)ctx.getChannel());
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object msg = e.getMessage();
        if (msg instanceof TSOProto.Request) {
            TSOProto.Request request = (TSOProto.Request)msg;
            if (request.hasHandshakeRequest()) {
                this.checkHandshake(ctx, request.getHandshakeRequest());
                return;
            }
            if (!this.handshakeCompleted(ctx)) {
                LOG.error("Handshake not completed. Closing channel {}", (Object)ctx.getChannel());
                ctx.getChannel().close();
            }
            if (request.hasTimestampRequest()) {
                this.requestProcessor.timestampRequest(ctx.getChannel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else if (request.hasCommitRequest()) {
                TSOProto.CommitRequest cr = request.getCommitRequest();
                this.requestProcessor.commitRequest(cr.getStartTimestamp(), cr.getCellIdList(), cr.getTableIdList(), cr.getIsRetry(), ctx.getChannel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else if (request.hasFenceRequest()) {
                TSOProto.FenceRequest fr = request.getFenceRequest();
                this.requestProcessor.fenceRequest(fr.getTableId(), ctx.getChannel(), MonitoringContextFactory.getInstance(this.config, this.metrics));
            } else {
                LOG.error("Invalid request {}. Closing channel {}", (Object)request, (Object)ctx.getChannel());
                ctx.getChannel().close();
            }
        } else {
            LOG.error("Unknown message type", msg);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (e.getCause() instanceof ClosedChannelException) {
            LOG.warn("ClosedChannelException caught. Cause: ", e.getCause());
            return;
        }
        LOG.warn("Unexpected exception from downstream. Closing channel {} {}", (Object)ctx.getChannel(), (Object)e.getCause());
        ctx.getChannel().close();
    }

    @Override
    public void close() throws IOException {
        this.closeConnection();
        this.factory.releaseExternalResources();
    }

    private void checkHandshake(ChannelHandlerContext ctx, TSOProto.HandshakeRequest request) {
        TSOProto.HandshakeResponse.Builder response = TSOProto.HandshakeResponse.newBuilder();
        if (request.hasClientCapabilities()) {
            response.setClientCompatible(true).setServerCapabilities(TSOProto.Capabilities.newBuilder().build());
            TSOChannelContext tsoCtx = new TSOChannelContext();
            tsoCtx.setHandshakeComplete();
            ctx.setAttachment(tsoCtx);
        } else {
            response.setClientCompatible(false);
        }
        response.setLowLatency(this.config.getLowLatency());
        ctx.getChannel().write(TSOProto.Response.newBuilder().setHandshakeResponse(response.build()).build());
    }

    private boolean handshakeCompleted(ChannelHandlerContext ctx) {
        Object o = ctx.getAttachment();
        if (o instanceof TSOChannelContext) {
            TSOChannelContext tsoCtx = (TSOChannelContext)o;
            return tsoCtx.getHandshakeComplete();
        }
        return false;
    }

    static class TSOPipelineFactory
    implements ChannelPipelineFactory {
        private final ChannelHandler handler;

        TSOPipelineFactory(ChannelHandler handler) {
            this.handler = handler;
        }

        @Override
        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("lengthbaseddecoder", new LengthFieldBasedFrameDecoder(0xA00000, 0, 4, 0, 4));
            pipeline.addLast("lengthprepender", new LengthFieldPrepender(4));
            pipeline.addLast("protobufdecoder", new ProtobufDecoder((MessageLite)TSOProto.Request.getDefaultInstance()));
            pipeline.addLast("protobufencoder", new ProtobufEncoder());
            pipeline.addLast("handler", this.handler);
            return pipeline;
        }
    }

    private static class TSOChannelContext {
        boolean handshakeComplete = false;

        TSOChannelContext() {
        }

        boolean getHandshakeComplete() {
            return this.handshakeComplete;
        }

        void setHandshakeComplete() {
            this.handshakeComplete = true;
        }
    }
}

