/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;

public class ColumnAlreadyExistsException
extends SQLException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.COLUMN_EXIST_IN_DEF;
    private final String schemaName;
    private final String tableName;
    private final String columnName;

    public ColumnAlreadyExistsException(String schemaName, String tableName, String columnName) {
        super(new SQLExceptionInfo.Builder(code).setColumnName(columnName).setSchemaName(schemaName).setTableName(tableName).build().toString(), code.getSQLState(), code.getErrorCode(), null);
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

