/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PBooleanArray
extends PArrayDataType<boolean[]> {
    public static final PBooleanArray INSTANCE = new PBooleanArray();

    private PBooleanArray() {
        super("BOOLEAN ARRAY", 3000 + PBoolean.INSTANCE.getSqlType(), PhoenixArray.class, null, 25);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PBoolean.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PBoolean.INSTANCE, sortOrder, maxLength, scale, PBoolean.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        boolean[] booleanArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveBooleanPhoenixArray pArr = (PhoenixArray.PrimitiveBooleanPhoenixArray)value;
        for (boolean b : booleanArr = (boolean[])pArr.array) {
            if (super.isCoercibleTo((PDataType)PInteger.INSTANCE, b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PBoolean.INSTANCE, arrayLength, maxLength);
    }
}

