/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.types;

import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PArrayDataType;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PUnsignedDate;
import org.apache.phoenix.schema.types.PUnsignedDouble;
import org.apache.phoenix.schema.types.PUnsignedTime;
import org.apache.phoenix.schema.types.PUnsignedTimestamp;
import org.apache.phoenix.schema.types.PhoenixArray;

public class PUnsignedDoubleArray
extends PArrayDataType<double[]> {
    public static final PUnsignedDoubleArray INSTANCE = new PUnsignedDoubleArray();

    private PUnsignedDoubleArray() {
        super("UNSIGNED_DOUBLE ARRAY", 3000 + PUnsignedDouble.INSTANCE.getSqlType(), PhoenixArray.class, null, 47);
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public int compareTo(Object lhs, Object rhs, PDataType rhsType) {
        return this.compareTo(lhs, rhs);
    }

    @Override
    public Integer getByteSize() {
        return null;
    }

    @Override
    public byte[] toBytes(Object object) {
        return this.toBytes(object, SortOrder.ASC);
    }

    @Override
    public byte[] toBytes(Object object, SortOrder sortOrder) {
        return this.toBytes(object, PUnsignedDouble.INSTANCE, sortOrder);
    }

    @Override
    public Object toObject(byte[] bytes, int offset, int length, PDataType actualType, SortOrder sortOrder, Integer maxLength, Integer scale) {
        return this.toObject(bytes, offset, length, PUnsignedDouble.INSTANCE, sortOrder, maxLength, scale, PUnsignedDouble.INSTANCE);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType) {
        return this.isCoercibleTo(targetType, this);
    }

    @Override
    public boolean isCoercibleTo(PDataType targetType, Object value) {
        double[] doubleArr;
        if (value == null) {
            return true;
        }
        PhoenixArray.PrimitiveDoublePhoenixArray pArr = (PhoenixArray.PrimitiveDoublePhoenixArray)value;
        double[] dArray = doubleArr = (double[])pArr.array;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double i2 = dArray[i];
            if (super.isCoercibleTo((PDataType)PUnsignedDouble.INSTANCE, i2) || super.isCoercibleTo((PDataType)PUnsignedTimestamp.INSTANCE, i2) || super.isCoercibleTo((PDataType)PUnsignedTime.INSTANCE, i2) || super.isCoercibleTo((PDataType)PUnsignedDate.INSTANCE, i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getSampleValue(Integer maxLength, Integer arrayLength) {
        return this.getSampleValue(PUnsignedDouble.INSTANCE, arrayLength, maxLength);
    }
}

