/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.schema.types.PSmallint;

public final class ViewIndexIdRetrieveUtil {
    public static final int VIEW_INDEX_ID_BIGINT_TYPE_PTR_LEN = 9;
    public static final int VIEW_INDEX_ID_SMALLINT_TYPE_VALUE_LEN = 3;
    public static final int NULL_DATA_TYPE_VALUE = 0;

    private ViewIndexIdRetrieveUtil() {
    }

    public static Cell buildNewCell(Cell viewIndexIdCell, byte[] newVal) {
        KeyValue keyValue = new KeyValue(viewIndexIdCell.getRowArray(), viewIndexIdCell.getRowOffset(), (int)viewIndexIdCell.getRowLength(), viewIndexIdCell.getFamilyArray(), viewIndexIdCell.getFamilyOffset(), (int)viewIndexIdCell.getFamilyLength(), viewIndexIdCell.getQualifierArray(), viewIndexIdCell.getQualifierOffset(), viewIndexIdCell.getQualifierLength(), viewIndexIdCell.getTimestamp(), KeyValue.Type.Put, newVal, 0, newVal.length);
        keyValue.setSequenceId(viewIndexIdCell.getSequenceId());
        return keyValue;
    }

    public static Cell getRetrievedViewIndexIdCell(Cell viewIndexIdCell, boolean isShortToLong) {
        ImmutableBytesWritable columnValue = new ImmutableBytesWritable(CellUtil.cloneValue((Cell)viewIndexIdCell));
        ImmutableBytesWritable newValue = new ImmutableBytesWritable();
        byte[] newBytes = isShortToLong ? PLong.INSTANCE.toBytes(PSmallint.INSTANCE.toObject(columnValue.get())) : PSmallint.INSTANCE.toBytes(PLong.INSTANCE.toObject(columnValue.get()));
        newValue.set(newBytes);
        return ViewIndexIdRetrieveUtil.buildNewCell(viewIndexIdCell, newValue.get());
    }
}

