/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.pherf.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.phoenix.pherf.configuration.DataOverride;
import org.apache.phoenix.pherf.configuration.Ddl;
import org.apache.phoenix.pherf.configuration.IdleTime;
import org.apache.phoenix.pherf.configuration.LoadProfile;
import org.apache.phoenix.pherf.configuration.QuerySet;
import org.apache.phoenix.pherf.configuration.Upsert;
import org.apache.phoenix.pherf.configuration.UserDefined;
import org.apache.phoenix.pherf.configuration.WriteParams;
import org.apache.phoenix.pherf.configuration.XMLConfigParser;
import org.apache.phoenix.pherf.util.PhoenixUtil;
import org.apache.phoenix.thirdparty.com.google.common.base.Preconditions;

@XmlRootElement(namespace="org.apache.phoenix.pherf.configuration.DataModel")
public class Scenario {
    private String tableName;
    private int rowCount;
    private Map<String, String> phoenixProperties;
    private WriteParams writeParams = null;
    private DataOverride dataOverride;
    private List<QuerySet> querySet = new ArrayList<QuerySet>();
    private List<Upsert> upsertSet = new ArrayList<Upsert>();
    private List<IdleTime> idleTimes = new ArrayList<IdleTime>();
    private List<UserDefined> udfs = new ArrayList<UserDefined>();
    private LoadProfile loadProfile = null;
    private String name;
    private String generatorName;
    private String tenantId;
    private List<Ddl> preScenarioDdls;
    private List<Ddl> postScenarioDdls;

    public boolean equals(Object object) {
        if (!(object instanceof Scenario)) {
            return false;
        }
        Scenario scenario = (Scenario)object;
        return this.tableName.equals(scenario.getTableName());
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 38).appendSuper(super.hashCode()).append(this.tableName).toHashCode();
    }

    @XmlAttribute
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @XmlAttribute
    public String getGeneratorName() {
        return this.generatorName;
    }

    public void setGeneratorName(String name) {
        this.generatorName = name;
    }

    @XmlAttribute
    public int getRowCount() {
        return PhoenixUtil.getRowCountOverride() == 0 ? this.rowCount : PhoenixUtil.getRowCountOverride();
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Map<String, String> getPhoenixProperties() {
        return this.phoenixProperties;
    }

    public void setPhoenixProperties(Map<String, String> phoenixProperty) {
        this.phoenixProperties = phoenixProperty;
    }

    @XmlElement
    public DataOverride getDataOverride() {
        return this.dataOverride;
    }

    public void setDataOverride(DataOverride dataOverride) {
        this.dataOverride = dataOverride;
    }

    public List<QuerySet> getQuerySet() {
        return this.querySet;
    }

    public void setQuerySet(List<QuerySet> querySet) {
        this.querySet = querySet;
    }

    public String getSchemaName() {
        return XMLConfigParser.parseSchemaName(this.tableName);
    }

    public String getTableNameWithoutSchemaName() {
        return XMLConfigParser.parseTableName(this.tableName);
    }

    @XmlAttribute
    public String getName() {
        Preconditions.checkNotNull(this.name);
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public WriteParams getWriteParams() {
        return this.writeParams;
    }

    public void setWriteParams(WriteParams writeParams) {
        this.writeParams = writeParams;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Name:" + this.name);
        stringBuilder.append("Table Name:" + this.tableName);
        stringBuilder.append("Row Count:" + this.rowCount);
        stringBuilder.append("Data Override:" + this.dataOverride);
        for (QuerySet query : this.querySet) {
            stringBuilder.append(query + ";");
        }
        return stringBuilder.toString();
    }

    public List<Ddl> getPreScenarioDdls() {
        return this.preScenarioDdls;
    }

    @XmlElementWrapper(name="preScenarioDdls")
    @XmlElement(name="ddl")
    public void setPreScenarioDdls(List<Ddl> preScenarioDdls) {
        this.preScenarioDdls = preScenarioDdls;
    }

    public List<Ddl> getPostScenarioDdls() {
        return this.postScenarioDdls;
    }

    @XmlElementWrapper(name="postScenarioDdls")
    @XmlElement(name="ddl")
    public void setPostScenarioDdls(List<Ddl> postScenarioDdls) {
        this.postScenarioDdls = postScenarioDdls;
    }

    public List<Upsert> getUpserts() {
        return this.upsertSet;
    }

    @XmlElementWrapper(name="upserts")
    @XmlElement(name="upsert")
    public void setUpserts(List<Upsert> upsertSet) {
        this.upsertSet = upsertSet;
    }

    public List<IdleTime> getIdleTimes() {
        return this.idleTimes;
    }

    @XmlElementWrapper(name="idleTimes")
    @XmlElement(name="idleTime")
    public void setIdleTimes(List<IdleTime> idleTimes) {
        this.idleTimes = idleTimes;
    }

    public List<UserDefined> getUdfs() {
        return this.udfs;
    }

    @XmlElementWrapper(name="udfs")
    @XmlElement(name="udf")
    public void setUdfs(List<UserDefined> udfs) {
        this.udfs = udfs;
    }

    public LoadProfile getLoadProfile() {
        return this.loadProfile;
    }

    public void setLoadProfile(LoadProfile loadProfile) {
        this.loadProfile = loadProfile;
    }
}

