/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcNewInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcNewOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.Hadoop23Shims;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPredicatePushdown;
import org.apache.pig.LoadPushDown;
import org.apache.pig.PigWarning;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreResources;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.data.Tuple;
import org.apache.pig.hive.HiveShims;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.impl.util.hive.HiveUtils;
import org.joda.time.DateTime;

public class OrcStorage
extends LoadFunc
implements StoreFuncInterface,
LoadMetadata,
LoadPushDown,
LoadPredicatePushdown,
StoreResources {
    private static final String SARG_PUSHDOWN = "sarg.pushdown";
    protected RecordReader in = null;
    protected RecordWriter writer = null;
    private TypeInfo typeInfo = null;
    private ObjectInspector oi = null;
    private OrcSerde serde = new OrcSerde();
    private String signature;
    private Long stripeSize;
    private Integer rowIndexStride;
    private Integer bufferSize;
    private Boolean blockPadding;
    private Boolean keepSingleFieldTuple = false;
    private CompressionKind compress;
    private String versionName;
    private static final Options validOptions;
    private final CommandLineParser parser = new GnuParser();
    protected static final Log log;
    protected boolean[] mRequiredColumns = null;
    private static final String SchemaSignatureSuffix = "_schema";
    private static final String RequiredColumnsSuffix = "_columns";
    private static final String SearchArgsSuffix = "_sarg";

    public OrcStorage() {
    }

    public OrcStorage(String options) {
        String[] optsArr = options.split(" ");
        try {
            CommandLine configuredOptions = this.parser.parse(validOptions, optsArr);
            if (configuredOptions.hasOption('s')) {
                this.stripeSize = Long.parseLong(configuredOptions.getOptionValue('s'));
            }
            if (configuredOptions.hasOption('r')) {
                this.rowIndexStride = Integer.parseInt(configuredOptions.getOptionValue('r'));
            }
            if (configuredOptions.hasOption('b')) {
                this.bufferSize = Integer.parseInt(configuredOptions.getOptionValue('b'));
            }
            this.blockPadding = configuredOptions.hasOption('p');
            if (configuredOptions.hasOption('c')) {
                this.compress = CompressionKind.valueOf((String)configuredOptions.getOptionValue('c'));
            }
            if (configuredOptions.hasOption('v')) {
                this.versionName = HiveShims.normalizeOrcVersionName(configuredOptions.getOptionValue('v'));
            }
            this.keepSingleFieldTuple = configuredOptions.hasOption('k');
        }
        catch (ParseException e) {
            log.error((Object)"Exception in OrcStorage", (Throwable)e);
            log.error((Object)("OrcStorage called with arguments " + options));
            this.warn("ParseException in OrcStorage", PigWarning.UDF_WARNING_1);
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("OrcStorage(',', '[options]')", validOptions);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath(location, curDir);
    }

    @Override
    public OutputFormat getOutputFormat() throws IOException {
        return new OrcNewOutputFormat();
    }

    @Override
    public void setStoreLocation(String location, Job job) throws IOException {
        if (!UDFContext.getUDFContext().isFrontend()) {
            HiveShims.setOrcConfigOnJob(job, this.stripeSize, this.rowIndexStride, this.bufferSize, this.blockPadding, this.compress, this.versionName);
        }
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
        if (this.typeInfo == null) {
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            this.typeInfo = (TypeInfo)ObjectSerializer.deserialize(p.getProperty(this.signature + SchemaSignatureSuffix));
        }
        if (this.oi == null) {
            this.oi = HiveUtils.createObjectInspector(this.typeInfo, this.keepSingleFieldTuple);
        }
    }

    @Override
    public void checkSchema(ResourceSchema rs) throws IOException {
        ResourceSchema.ResourceFieldSchema fs = new ResourceSchema.ResourceFieldSchema();
        fs.setType((byte)110);
        fs.setSchema(rs);
        this.typeInfo = HiveUtils.getTypeInfo(fs, this.keepSingleFieldTuple);
        Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
        p.setProperty(this.signature + SchemaSignatureSuffix, ObjectSerializer.serialize((Serializable)this.typeInfo));
    }

    @Override
    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    @Override
    public void putNext(Tuple t) throws IOException {
        try {
            this.writer.write(null, (Object)this.serde.serialize((Object)t, this.oi));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setStoreFuncUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl(location, job);
    }

    @Override
    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        Set<Path> paths;
        Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
        if (!UDFContext.getUDFContext().isFrontend()) {
            this.typeInfo = (TypeInfo)ObjectSerializer.deserialize(p.getProperty(this.signature + SchemaSignatureSuffix));
        } else if (this.typeInfo == null) {
            this.typeInfo = this.getTypeInfo(location, job);
        }
        if (this.typeInfo != null && this.oi == null) {
            this.oi = OrcStruct.createObjectInspector((TypeInfo)this.typeInfo);
        }
        if (!UDFContext.getUDFContext().isFrontend()) {
            if (p.getProperty(this.signature + RequiredColumnsSuffix) != null) {
                this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize(p.getProperty(this.signature + RequiredColumnsSuffix));
                job.getConfiguration().setBoolean("hive.io.file.read.all.columns", false);
                job.getConfiguration().set("hive.io.file.readcolumn.ids", this.getReqiredColumnIdString(this.mRequiredColumns));
                if (p.getProperty(this.signature + SearchArgsSuffix) != null) {
                    job.getConfiguration().set("hive.io.file.readcolumn.names", this.getReqiredColumnNamesString(this.getSchema(location, job), this.mRequiredColumns));
                }
            } else if (p.getProperty(this.signature + SearchArgsSuffix) != null) {
                job.getConfiguration().set("hive.io.file.readcolumn.names", this.getReqiredColumnNamesString(this.getSchema(location, job)));
            }
            if (p.getProperty(this.signature + SearchArgsSuffix) != null) {
                job.getConfiguration().set(SARG_PUSHDOWN, p.getProperty(this.signature + SearchArgsSuffix));
            }
        }
        if ((paths = OrcStorage.getGlobPaths(location, job.getConfiguration(), true)).isEmpty()) {
            throw new IOException("Input path '" + location + "' is not found");
        }
        FileInputFormat.setInputPaths((Job)job, (Path[])paths.toArray(new Path[paths.size()]));
    }

    private String getReqiredColumnIdString(boolean[] requiredColumns) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < requiredColumns.length; ++i) {
            if (!requiredColumns[i]) continue;
            sb.append(i).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getReqiredColumnNamesString(ResourceSchema schema) {
        StringBuilder sb = new StringBuilder();
        for (ResourceSchema.ResourceFieldSchema field : schema.getFields()) {
            sb.append(field.getName()).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getReqiredColumnNamesString(ResourceSchema schema, boolean[] requiredColumns) {
        StringBuilder sb = new StringBuilder();
        ResourceSchema.ResourceFieldSchema[] fields = schema.getFields();
        for (int i = 0; i < requiredColumns.length; ++i) {
            if (!requiredColumns[i]) continue;
            sb.append(fields[i]).append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        return new OrcNewInputFormat();
    }

    @Override
    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.in = reader;
    }

    @Override
    public Tuple getNext() throws IOException {
        try {
            boolean notDone = this.in.nextKeyValue();
            if (!notDone) {
                return null;
            }
            Object value = this.in.getCurrentValue();
            Tuple t = (Tuple)HiveUtils.convertHiveToPig(value, this.oi, this.mRequiredColumns);
            return t;
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, e);
        }
    }

    @Override
    public List<String> getShipFiles() {
        Class[] classList = HiveShims.getOrcDependentClasses(Hadoop23Shims.class);
        return FuncUtils.getShipFiles(classList);
    }

    private static Path getFirstFile(String location, FileSystem fs, PathFilter filter) throws IOException {
        String[] locations = OrcStorage.getPathStrings(location);
        Path[] paths = new Path[locations.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = new Path(locations[i]);
        }
        ArrayList<FileStatus> statusList = new ArrayList<FileStatus>();
        for (int i = 0; i < paths.length; ++i) {
            FileStatus[] files = fs.globStatus(paths[i]);
            if (files == null) continue;
            for (FileStatus tempf : files) {
                statusList.add(tempf);
            }
        }
        FileStatus[] statusArray = statusList.toArray(new FileStatus[statusList.size()]);
        Path p = Utils.depthFirstSearchForFile(statusArray, fs, filter);
        return p;
    }

    @Override
    public ResourceSchema getSchema(String location, Job job) throws IOException {
        if (this.typeInfo == null) {
            this.typeInfo = this.getTypeInfo(location, job);
            if (this.typeInfo == null) {
                return null;
            }
        }
        ResourceSchema.ResourceFieldSchema fs = HiveUtils.getResourceFieldSchema(this.typeInfo);
        return fs.getSchema();
    }

    private TypeInfo getTypeInfo(String location, Job job) throws IOException {
        Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
        TypeInfo typeInfo = (TypeInfo)ObjectSerializer.deserialize(p.getProperty(this.signature + SchemaSignatureSuffix));
        if (typeInfo == null) {
            typeInfo = this.getTypeInfoFromLocation(location, job);
        }
        if (typeInfo != null) {
            p.setProperty(this.signature + SchemaSignatureSuffix, ObjectSerializer.serialize((Serializable)typeInfo));
        }
        return typeInfo;
    }

    private TypeInfo getTypeInfoFromLocation(String location, Job job) throws IOException {
        FileSystem fs = FileSystem.get((URI)new Path(location).toUri(), (Configuration)job.getConfiguration());
        Path path = OrcStorage.getFirstFile(location, fs, new NonEmptyOrcFileFilter(fs));
        if (path == null) {
            log.info((Object)("Cannot find any ORC files from " + location + ". Probably multiple load store in script."));
            return null;
        }
        Reader reader = OrcFile.createReader((FileSystem)fs, (Path)path);
        ObjectInspector oip = reader.getObjectInspector();
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oip);
    }

    @Override
    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    @Override
    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int schemaSize = ((StructTypeInfo)this.typeInfo).getAllStructFieldTypeInfos().size();
            this.mRequiredColumns = new boolean[schemaSize];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            try {
                p.setProperty(this.signature + RequiredColumnsSuffix, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    @Override
    public List<String> getPredicateFields(String location, Job job) throws IOException {
        ResourceSchema schema = this.getSchema(location, job);
        ArrayList<String> predicateFields = new ArrayList<String>();
        block3: for (ResourceSchema.ResourceFieldSchema field : schema.getFields()) {
            switch (field.getType()) {
                case 5: 
                case 10: 
                case 15: 
                case 20: 
                case 25: 
                case 30: 
                case 55: 
                case 65: 
                case 70: {
                    predicateFields.add(field.getName());
                    continue block3;
                }
            }
        }
        return predicateFields;
    }

    @Override
    public List<Expression.OpType> getSupportedExpressionTypes() {
        ArrayList<Expression.OpType> types = new ArrayList<Expression.OpType>();
        types.add(Expression.OpType.OP_EQ);
        types.add(Expression.OpType.OP_NE);
        types.add(Expression.OpType.OP_GT);
        types.add(Expression.OpType.OP_GE);
        types.add(Expression.OpType.OP_LT);
        types.add(Expression.OpType.OP_LE);
        types.add(Expression.OpType.OP_IN);
        types.add(Expression.OpType.OP_BETWEEN);
        types.add(Expression.OpType.OP_NULL);
        types.add(Expression.OpType.OP_NOT);
        types.add(Expression.OpType.OP_AND);
        types.add(Expression.OpType.OP_OR);
        return types;
    }

    @Override
    public void setPushdownPredicate(Expression expr) throws IOException {
        SearchArgument sArg = this.getSearchArgument(expr);
        if (sArg != null) {
            log.info((Object)("Pushdown predicate expression is " + expr));
            log.info((Object)("Pushdown predicate SearchArgument is:\n" + sArg));
            Properties p = UDFContext.getUDFContext().getUDFProperties(this.getClass());
            try {
                Kryo kryo = new Kryo();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Output output = new Output((OutputStream)baos);
                kryo.writeObject(output, (Object)sArg);
                p.setProperty(this.signature + SearchArgsSuffix, new String(Base64.encodeBase64((byte[])output.toBytes())));
            }
            catch (Exception e) {
                throw new IOException("Cannot serialize SearchArgument: " + sArg);
            }
        }
    }

    @VisibleForTesting
    SearchArgument getSearchArgument(Expression expr) {
        boolean beginWithAnd;
        if (expr == null) {
            return null;
        }
        SearchArgument.Builder builder = SearchArgumentFactory.newBuilder();
        boolean bl = beginWithAnd = !expr.getOpType().equals((Object)Expression.OpType.OP_AND) && !expr.getOpType().equals((Object)Expression.OpType.OP_OR) && !expr.getOpType().equals((Object)Expression.OpType.OP_NOT);
        if (beginWithAnd) {
            builder.startAnd();
        }
        this.buildSearchArgument(expr, builder);
        if (beginWithAnd) {
            builder.end();
        }
        SearchArgument sArg = builder.build();
        return sArg;
    }

    private void buildSearchArgument(Expression expr, SearchArgument.Builder builder) {
        if (expr instanceof Expression.BinaryExpression) {
            Expression lhs = ((Expression.BinaryExpression)expr).getLhs();
            Expression rhs = ((Expression.BinaryExpression)expr).getRhs();
            switch (expr.getOpType()) {
                case OP_AND: {
                    builder.startAnd();
                    this.buildSearchArgument(lhs, builder);
                    this.buildSearchArgument(rhs, builder);
                    builder.end();
                    break;
                }
                case OP_OR: {
                    builder.startOr();
                    this.buildSearchArgument(lhs, builder);
                    this.buildSearchArgument(rhs, builder);
                    builder.end();
                    break;
                }
                case OP_EQ: {
                    HiveShims.addEqualsOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    break;
                }
                case OP_NE: {
                    builder.startNot();
                    HiveShims.addEqualsOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    builder.end();
                    break;
                }
                case OP_LT: {
                    HiveShims.addLessThanOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    break;
                }
                case OP_LE: {
                    HiveShims.addLessThanEqualsOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    break;
                }
                case OP_GT: {
                    builder.startNot();
                    HiveShims.addLessThanEqualsOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    builder.end();
                    break;
                }
                case OP_GE: {
                    builder.startNot();
                    HiveShims.addLessThanOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), this.getExpressionValue(rhs));
                    builder.end();
                    break;
                }
                case OP_BETWEEN: {
                    Expression.BetweenExpression between = (Expression.BetweenExpression)rhs;
                    HiveShims.addBetweenOpToBuilder(builder, this.getColumnName(lhs), this.getColumnType(lhs), HiveShims.getSearchArgObjValue(between.getLower()), HiveShims.getSearchArgObjValue(between.getUpper()));
                }
                case OP_IN: {
                    Expression.InExpression in = (Expression.InExpression)rhs;
                    builder.in(this.getColumnName(lhs), new Object[]{this.getColumnType(lhs), this.getSearchArgObjValues(in.getValues()).toArray()});
                }
                default: {
                    throw new RuntimeException("Unsupported binary expression type: " + (Object)((Object)expr.getOpType()) + " in " + expr);
                }
            }
        } else if (expr instanceof Expression.UnaryExpression) {
            Expression unaryExpr = ((Expression.UnaryExpression)expr).getExpression();
            switch (expr.getOpType()) {
                case OP_NULL: {
                    HiveShims.addIsNullOpToBuilder(builder, this.getColumnName(unaryExpr), this.getColumnType(unaryExpr));
                    break;
                }
                case OP_NOT: {
                    builder.startNot();
                    this.buildSearchArgument(unaryExpr, builder);
                    builder.end();
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported unary expression type: " + (Object)((Object)expr.getOpType()) + " in " + expr);
                }
            }
        } else {
            throw new RuntimeException("Unsupported expression type: " + (Object)((Object)expr.getOpType()) + " in " + expr);
        }
    }

    private String getColumnName(Expression expr) {
        try {
            return ((Expression.Column)expr).getName();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Expected a Column but found " + expr.getClass().getName() + " in expression " + expr, e);
        }
    }

    private PredicateLeaf.Type getColumnType(Expression expr) {
        try {
            return HiveUtils.getDataTypeForSearchArgs(expr.getDataType());
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Expected a Column but found " + expr.getClass().getName() + " in expression " + expr, e);
        }
    }

    private Object getExpressionValue(Expression expr) {
        switch (expr.getOpType()) {
            case TERM_COL: {
                return ((Expression.Column)expr).getName();
            }
            case TERM_CONST: {
                return HiveShims.getSearchArgObjValue(((Expression.Const)expr).getValue());
            }
        }
        throw new RuntimeException("Unsupported expression type: " + (Object)((Object)expr.getOpType()) + " in " + expr);
    }

    private List<Object> getSearchArgObjValues(List<Object> values) {
        if (!(values.get(0) instanceof BigInteger || values.get(0) instanceof BigDecimal || values.get(0) instanceof DateTime)) {
            return values;
        }
        ArrayList<Object> newValues = new ArrayList<Object>(values.size());
        for (Object value : values) {
            newValues.add(HiveShims.getSearchArgObjValue(value));
        }
        return values;
    }

    @Override
    public Boolean supportsParallelWriteToStoreLocation() {
        return true;
    }

    static {
        log = LogFactory.getLog(OrcStorage.class);
        validOptions = new Options();
        validOptions.addOption("s", "stripeSize", true, "Set the stripe size for the file");
        validOptions.addOption("r", "rowIndexStride", true, "Set the distance between entries in the row index");
        validOptions.addOption("b", "bufferSize", true, "The size of the memory buffers used for compressing and storing the stripe in memory");
        validOptions.addOption("p", "blockPadding", false, "Sets whether the HDFS blocks are padded to prevent stripes from straddling blocks");
        validOptions.addOption("c", "compress", true, "Sets the generic compression that is used to compress the data");
        validOptions.addOption("k", "keepSingleFieldTuple", false, "Sets whether to keep Tuple(struct) schema inside a Bag(array) even if the tuple only contains a single field");
        validOptions.addOption("v", "version", true, "Sets the version of the file that will be written");
    }

    public static class NonEmptyOrcFileFilter
    implements PathFilter {
        private FileSystem fs;

        public NonEmptyOrcFileFilter(FileSystem fs) {
            this.fs = fs;
        }

        public boolean accept(Path path) {
            try {
                Reader reader = OrcFile.createReader((FileSystem)this.fs, (Path)path);
                ObjectInspector oip = reader.getObjectInspector();
                ResourceSchema.ResourceFieldSchema rs = HiveUtils.getResourceFieldSchema(TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)oip));
                if (rs.getSchema().getFields().length != 0) {
                    return true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }
    }
}

