/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.spark;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.pig.tools.pigstats.spark.SparkCounter;
import org.apache.spark.api.java.JavaSparkContext;

public abstract class SparkCounterGroup<T>
implements Serializable {
    protected String groupName;
    protected String groupDisplayName;
    protected Map<String, SparkCounter<T>> sparkCounters;
    protected transient JavaSparkContext javaSparkContext;

    private SparkCounterGroup() {
    }

    public SparkCounterGroup(String groupName, String groupDisplayName, JavaSparkContext javaSparkContext) {
        this.groupName = groupName;
        this.groupDisplayName = groupDisplayName;
        this.javaSparkContext = javaSparkContext;
        this.sparkCounters = new HashMap<String, SparkCounter<T>>();
    }

    public abstract void createCounter(String var1, T var2);

    public SparkCounter getCounter(String name) {
        return this.sparkCounters.get(name);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupDisplayName() {
        return this.groupDisplayName;
    }

    public void setGroupDisplayName(String groupDisplayName) {
        this.groupDisplayName = groupDisplayName;
    }

    public Map<String, SparkCounter<T>> getSparkCounters() {
        return this.sparkCounters;
    }

    public static class MapSparkCounterGroup
    extends SparkCounterGroup<Map<String, Long>> {
        public MapSparkCounterGroup(String groupName, String groupDisplayName, JavaSparkContext javaSparkContext) {
            super(groupName, groupDisplayName, javaSparkContext);
        }

        @Override
        public void createCounter(String name, Map<String, Long> initValue) {
            SparkCounter.MapSparkCounter counter = new SparkCounter.MapSparkCounter(name, name, this.groupName, initValue, this.javaSparkContext);
            this.sparkCounters.put(name, counter);
        }
    }

    public static class LongSparkCounterGroup
    extends SparkCounterGroup<Long> {
        public LongSparkCounterGroup(String groupName, String groupDisplayName, JavaSparkContext javaSparkContext) {
            super(groupName, groupDisplayName, javaSparkContext);
        }

        @Override
        public void createCounter(String name, Long initValue) {
            SparkCounter.LongSparkCounter counter = new SparkCounter.LongSparkCounter(name, name, this.groupName, initValue, this.javaSparkContext);
            this.sparkCounters.put(name, counter);
        }
    }
}

