/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class Range
implements WritableComparable<Range> {
    private Key start;
    private Key stop;
    private boolean startKeyInclusive;
    private boolean stopKeyInclusive;
    private boolean infiniteStartKey;
    private boolean infiniteStopKey;

    public Range() {
        this((Key)null, true, (Key)null, true);
    }

    public Range(Key startKey, Key endKey) {
        this(startKey, true, endKey, true);
    }

    public Range(CharSequence row) {
        this(row, true, row, true);
    }

    public Range(Text row) {
        this(row, true, row, true);
    }

    public Range(Text startRow, Text endRow) {
        this(startRow, true, endRow, true);
    }

    public Range(CharSequence startRow, CharSequence endRow) {
        this(startRow, true, endRow, true);
    }

    public Range(Text startRow, boolean startRowInclusive, Text endRow, boolean endRowInclusive) {
        this(startRow == null ? null : (startRowInclusive ? new Key(startRow) : new Key(startRow).followingKey(PartialKey.ROW)), true, endRow == null ? null : (endRowInclusive ? new Key(endRow).followingKey(PartialKey.ROW) : new Key(endRow)), false);
    }

    public Range(CharSequence startRow, boolean startRowInclusive, CharSequence endRow, boolean endRowInclusive) {
        this(startRow == null ? null : new Text(((Object)startRow).toString()), startRowInclusive, endRow == null ? null : new Text(((Object)endRow).toString()), endRowInclusive);
    }

    public Range(Key startKey, boolean startKeyInclusive, Key endKey, boolean endKeyInclusive) {
        this.start = startKey;
        this.startKeyInclusive = startKeyInclusive;
        this.infiniteStartKey = startKey == null;
        this.stop = endKey;
        this.stopKeyInclusive = endKeyInclusive;
        boolean bl = this.infiniteStopKey = this.stop == null;
        if (!this.infiniteStartKey && !this.infiniteStopKey && this.beforeStartKey(endKey)) {
            throw new IllegalArgumentException("Start key must be less than end key in range (" + startKey + ", " + endKey + ")");
        }
    }

    public Range(Range range) {
        this(range.start, range.stop, range.startKeyInclusive, range.stopKeyInclusive, range.infiniteStartKey, range.infiniteStopKey);
    }

    public Range(Key start, Key stop, boolean startKeyInclusive, boolean stopKeyInclusive, boolean infiniteStartKey, boolean infiniteStopKey) {
        if (infiniteStartKey && start != null) {
            throw new IllegalArgumentException();
        }
        if (infiniteStopKey && stop != null) {
            throw new IllegalArgumentException();
        }
        this.start = start;
        this.stop = stop;
        this.startKeyInclusive = startKeyInclusive;
        this.stopKeyInclusive = stopKeyInclusive;
        this.infiniteStartKey = infiniteStartKey;
        this.infiniteStopKey = infiniteStopKey;
    }

    public Range(TRange trange) {
        this(trange.start == null ? null : new Key(trange.start), trange.stop == null ? null : new Key(trange.stop), trange.startKeyInclusive, trange.stopKeyInclusive, trange.infiniteStartKey, trange.infiniteStopKey);
    }

    public Key getStartKey() {
        if (this.infiniteStartKey) {
            return null;
        }
        return this.start;
    }

    public boolean beforeStartKey(Key key) {
        if (this.infiniteStartKey) {
            return false;
        }
        if (this.startKeyInclusive) {
            return key.compareTo(this.start) < 0;
        }
        return key.compareTo(this.start) <= 0;
    }

    public Key getEndKey() {
        if (this.infiniteStopKey) {
            return null;
        }
        return this.stop;
    }

    public boolean afterEndKey(Key key) {
        if (this.infiniteStopKey) {
            return false;
        }
        if (this.stopKeyInclusive) {
            return this.stop.compareTo(key) < 0;
        }
        return this.stop.compareTo(key) <= 0;
    }

    public int hashCode() {
        int startHash;
        int n = this.infiniteStartKey ? 0 : (startHash = this.start.hashCode() + (this.startKeyInclusive ? 1 : 0));
        int stopHash = this.infiniteStopKey ? 0 : this.stop.hashCode() + (this.stopKeyInclusive ? 1 : 0);
        return startHash + stopHash;
    }

    public boolean equals(Object o) {
        if (o instanceof Range) {
            return this.equals((Range)o);
        }
        return false;
    }

    public boolean equals(Range otherRange) {
        return this.compareTo(otherRange) == 0;
    }

    public int compareTo(Range o) {
        int comp;
        if (this.infiniteStartKey) {
            comp = o.infiniteStartKey ? 0 : -1;
        } else if (o.infiniteStartKey) {
            comp = 1;
        } else {
            comp = this.start.compareTo(o.start);
            if (comp == 0) {
                if (this.startKeyInclusive && !o.startKeyInclusive) {
                    comp = -1;
                } else if (!this.startKeyInclusive && o.startKeyInclusive) {
                    comp = 1;
                }
            }
        }
        if (comp == 0) {
            if (this.infiniteStopKey) {
                comp = o.infiniteStopKey ? 0 : 1;
            } else if (o.infiniteStopKey) {
                comp = -1;
            } else {
                comp = this.stop.compareTo(o.stop);
                if (comp == 0) {
                    if (this.stopKeyInclusive && !o.stopKeyInclusive) {
                        comp = 1;
                    } else if (!this.stopKeyInclusive && o.stopKeyInclusive) {
                        comp = -1;
                    }
                }
            }
        }
        return comp;
    }

    public boolean contains(Key key) {
        return !this.beforeStartKey(key) && !this.afterEndKey(key);
    }

    public static List<Range> mergeOverlapping(Collection<Range> ranges) {
        if (ranges.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Range> ral = new ArrayList<Range>(ranges);
        Collections.sort(ral);
        ArrayList<Range> ret = new ArrayList<Range>(ranges.size());
        Range currentRange = (Range)ral.get(0);
        boolean currentStartKeyInclusive = ((Range)ral.get((int)0)).startKeyInclusive;
        for (int i = 1; i < ral.size() && !currentRange.infiniteStopKey; ++i) {
            boolean startKeysEqual;
            Range range = (Range)ral.get(i);
            if (range.infiniteStartKey) {
                assert (currentRange.infiniteStartKey);
                startKeysEqual = true;
            } else {
                startKeysEqual = currentRange.infiniteStartKey ? false : currentRange.start.equals(range.start);
            }
            if (startKeysEqual || currentRange.contains(range.start) || !currentRange.stopKeyInclusive && range.startKeyInclusive && range.start.equals(currentRange.stop)) {
                int cmp;
                if (!range.infiniteStopKey && (cmp = range.stop.compareTo(currentRange.stop)) <= 0 && (cmp != 0 || !range.stopKeyInclusive)) continue;
                currentRange = new Range(currentRange.getStartKey(), currentStartKeyInclusive, range.getEndKey(), range.stopKeyInclusive);
                continue;
            }
            ret.add(currentRange);
            currentRange = range;
            currentStartKeyInclusive = range.startKeyInclusive;
        }
        ret.add(currentRange);
        return ret;
    }

    public Range clip(Range range) {
        return this.clip(range, false);
    }

    public Range clip(Range range, boolean returnNullIfDisjoint) {
        Key sk = range.getStartKey();
        boolean ski = range.isStartKeyInclusive();
        Key ek = range.getEndKey();
        boolean eki = range.isEndKeyInclusive();
        if (range.getStartKey() == null) {
            if (this.getStartKey() != null) {
                sk = this.getStartKey();
                ski = this.isStartKeyInclusive();
            }
        } else {
            if (this.afterEndKey(range.getStartKey()) || this.getEndKey() != null && range.getStartKey().equals(this.getEndKey()) && (!range.isStartKeyInclusive() || !this.isEndKeyInclusive())) {
                if (returnNullIfDisjoint) {
                    return null;
                }
                throw new IllegalArgumentException("Range " + range + " does not overlap " + this);
            }
            if (this.beforeStartKey(range.getStartKey())) {
                sk = this.getStartKey();
                ski = this.isStartKeyInclusive();
            }
        }
        if (range.getEndKey() == null) {
            if (this.getEndKey() != null) {
                ek = this.getEndKey();
                eki = this.isEndKeyInclusive();
            }
        } else {
            if (this.beforeStartKey(range.getEndKey()) || this.getStartKey() != null && range.getEndKey().equals(this.getStartKey()) && (!range.isEndKeyInclusive() || !this.isStartKeyInclusive())) {
                if (returnNullIfDisjoint) {
                    return null;
                }
                throw new IllegalArgumentException("Range " + range + " does not overlap " + this);
            }
            if (this.afterEndKey(range.getEndKey())) {
                ek = this.getEndKey();
                eki = this.isEndKeyInclusive();
            }
        }
        return new Range(sk, ski, ek, eki);
    }

    public Range bound(Column min, Column max) {
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("min column > max column " + min + " " + max);
        }
        Key sk = this.getStartKey();
        boolean ski = this.isStartKeyInclusive();
        if (sk != null) {
            ByteSequence cf = sk.getColumnFamilyData();
            ByteSequence cq = sk.getColumnQualifierData();
            ArrayByteSequence mincf = new ArrayByteSequence(min.columnFamily);
            ArrayByteSequence mincq = min.columnQualifier != null ? new ArrayByteSequence(min.columnQualifier) : new ArrayByteSequence(new byte[0]);
            int cmp = cf.compareTo(mincf);
            if (cmp < 0 || cmp == 0 && cq.compareTo(mincq) < 0) {
                ski = true;
                sk = new Key(sk.getRowData().toArray(), ((ByteSequence)mincf).toArray(), ((ByteSequence)mincq).toArray(), new byte[0], Long.MAX_VALUE, true);
            }
        }
        Key ek = this.getEndKey();
        boolean eki = this.isEndKeyInclusive();
        if (ek != null) {
            ByteSequence row = ek.getRowData();
            ByteSequence cf = ek.getColumnFamilyData();
            ByteSequence cq = ek.getColumnQualifierData();
            ByteSequence cv = ek.getColumnVisibilityData();
            ArrayByteSequence maxcf = new ArrayByteSequence(max.columnFamily);
            ArrayByteSequence maxcq = null;
            if (max.columnQualifier != null) {
                maxcq = new ArrayByteSequence(max.columnQualifier);
            }
            boolean set = false;
            int comp = cf.compareTo(maxcf);
            if (comp > 0) {
                set = true;
            } else if (comp == 0 && maxcq != null && cq.compareTo(maxcq) > 0) {
                set = true;
            } else if (!eki && row.length() > 0 && row.byteAt(row.length() - 1) == 0 && cf.length() == 0 && cq.length() == 0 && cv.length() == 0 && ek.getTimestamp() == Long.MAX_VALUE) {
                row = row.subSequence(0, row.length() - 1);
                set = true;
            }
            if (set) {
                eki = false;
                ek = maxcq == null ? new Key(row.toArray(), ((ByteSequence)maxcf).toArray(), new byte[0], new byte[0], 0L, false).followingKey(PartialKey.ROW_COLFAM) : new Key(row.toArray(), ((ByteSequence)maxcf).toArray(), ((ByteSequence)maxcq).toArray(), new byte[0], 0L, false).followingKey(PartialKey.ROW_COLFAM_COLQUAL);
            }
        }
        return new Range(sk, ski, ek, eki);
    }

    public String toString() {
        return (this.startKeyInclusive && this.start != null ? "[" : "(") + (this.start == null ? "-inf" : this.start) + "," + (this.stop == null ? "+inf" : this.stop) + (this.stopKeyInclusive && this.stop != null ? "]" : ")");
    }

    public void readFields(DataInput in) throws IOException {
        this.infiniteStartKey = in.readBoolean();
        this.infiniteStopKey = in.readBoolean();
        if (!this.infiniteStartKey) {
            this.start = new Key();
            this.start.readFields(in);
        } else {
            this.start = null;
        }
        if (!this.infiniteStopKey) {
            this.stop = new Key();
            this.stop.readFields(in);
        } else {
            this.stop = null;
        }
        this.startKeyInclusive = in.readBoolean();
        this.stopKeyInclusive = in.readBoolean();
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.infiniteStartKey);
        out.writeBoolean(this.infiniteStopKey);
        if (!this.infiniteStartKey) {
            this.start.write(out);
        }
        if (!this.infiniteStopKey) {
            this.stop.write(out);
        }
        out.writeBoolean(this.startKeyInclusive);
        out.writeBoolean(this.stopKeyInclusive);
    }

    public boolean isStartKeyInclusive() {
        return this.startKeyInclusive;
    }

    public boolean isEndKeyInclusive() {
        return this.stopKeyInclusive;
    }

    public TRange toThrift() {
        return new TRange(this.start == null ? null : this.start.toThrift(), this.stop == null ? null : this.stop.toThrift(), this.startKeyInclusive, this.stopKeyInclusive, this.infiniteStartKey, this.infiniteStopKey);
    }

    public boolean isInfiniteStartKey() {
        return this.infiniteStartKey;
    }

    public boolean isInfiniteStopKey() {
        return this.infiniteStopKey;
    }

    public static Range exact(Text row) {
        return new Range(row);
    }

    public static Range exact(Text row, Text cf) {
        Key startKey = new Key(row, cf);
        return new Range(startKey, true, startKey.followingKey(PartialKey.ROW_COLFAM), false);
    }

    public static Range exact(Text row, Text cf, Text cq) {
        Key startKey = new Key(row, cf, cq);
        return new Range(startKey, true, startKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL), false);
    }

    public static Range exact(Text row, Text cf, Text cq, Text cv) {
        Key startKey = new Key(row, cf, cq, cv);
        return new Range(startKey, true, startKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS), false);
    }

    public static Range exact(Text row, Text cf, Text cq, Text cv, long ts) {
        Key startKey = new Key(row, cf, cq, cv, ts);
        return new Range(startKey, true, startKey.followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS_TIME), false);
    }

    public static Text followingPrefix(Text prefix) {
        int changeIndex;
        byte[] prefixBytes = prefix.getBytes();
        for (changeIndex = prefix.getLength() - 1; changeIndex >= 0 && prefixBytes[changeIndex] == -1; --changeIndex) {
        }
        if (changeIndex < 0) {
            return null;
        }
        byte[] newBytes = new byte[changeIndex + 1];
        System.arraycopy(prefixBytes, 0, newBytes, 0, changeIndex + 1);
        int n = changeIndex;
        newBytes[n] = (byte)(newBytes[n] + 1);
        return new Text(newBytes);
    }

    public static Range prefix(Text rowPrefix) {
        Text fp = Range.followingPrefix(rowPrefix);
        return new Range(new Key(rowPrefix), true, fp == null ? null : new Key(fp), false);
    }

    public static Range prefix(Text row, Text cfPrefix) {
        Text fp = Range.followingPrefix(cfPrefix);
        return new Range(new Key(row, cfPrefix), true, fp == null ? new Key(row).followingKey(PartialKey.ROW) : new Key(row, fp), false);
    }

    public static Range prefix(Text row, Text cf, Text cqPrefix) {
        Text fp = Range.followingPrefix(cqPrefix);
        return new Range(new Key(row, cf, cqPrefix), true, fp == null ? new Key(row, cf).followingKey(PartialKey.ROW_COLFAM) : new Key(row, cf, fp), false);
    }

    public static Range prefix(Text row, Text cf, Text cq, Text cvPrefix) {
        Text fp = Range.followingPrefix(cvPrefix);
        return new Range(new Key(row, cf, cq, cvPrefix), true, fp == null ? new Key(row, cf, cq).followingKey(PartialKey.ROW_COLFAM_COLQUAL) : new Key(row, cf, cq, fp), false);
    }

    public static Range exact(CharSequence row) {
        return Range.exact(new Text(((Object)row).toString()));
    }

    public static Range exact(CharSequence row, CharSequence cf) {
        return Range.exact(new Text(((Object)row).toString()), new Text(((Object)cf).toString()));
    }

    public static Range exact(CharSequence row, CharSequence cf, CharSequence cq) {
        return Range.exact(new Text(((Object)row).toString()), new Text(((Object)cf).toString()), new Text(((Object)cq).toString()));
    }

    public static Range exact(CharSequence row, CharSequence cf, CharSequence cq, CharSequence cv) {
        return Range.exact(new Text(((Object)row).toString()), new Text(((Object)cf).toString()), new Text(((Object)cq).toString()), new Text(((Object)cv).toString()));
    }

    public static Range exact(CharSequence row, CharSequence cf, CharSequence cq, CharSequence cv, long ts) {
        return Range.exact(new Text(((Object)row).toString()), new Text(((Object)cf).toString()), new Text(((Object)cq).toString()), new Text(((Object)cv).toString()), ts);
    }

    public static Range prefix(CharSequence rowPrefix) {
        return Range.prefix(new Text(((Object)rowPrefix).toString()));
    }

    public static Range prefix(CharSequence row, CharSequence cfPrefix) {
        return Range.prefix(new Text(((Object)row).toString()), new Text(((Object)cfPrefix).toString()));
    }

    public static Range prefix(CharSequence row, CharSequence cf, CharSequence cqPrefix) {
        return Range.prefix(new Text(((Object)row).toString()), new Text(((Object)cf).toString()), new Text(((Object)cqPrefix).toString()));
    }

    public static Range prefix(CharSequence row, CharSequence cf, CharSequence cq, CharSequence cvPrefix) {
        return Range.prefix(new Text(((Object)row).toString()), new Text(((Object)cf).toString()), new Text(((Object)cq).toString()), new Text(((Object)cvPrefix).toString()));
    }
}

