/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.util.Iterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.OptionDescriber;

public class MinCombiner
extends LongCombiner {
    @Override
    public Long typedReduce(Key key, Iterator<Long> iter) {
        long min = Long.MAX_VALUE;
        while (iter.hasNext()) {
            Long l = iter.next();
            if (l >= min) continue;
            min = l;
        }
        return min;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("min");
        io.setDescription("MinCombiner interprets Values as Longs and finds their minimum.  A variety of encodings (variable length, fixed length, or string) are available");
        return io;
    }
}

