/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.records;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.util.FastNumberFormat;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TezTaskID
extends TezID {
    public static final String TASK = "task";
    private final int serializingHash;
    static final ThreadLocal<FastNumberFormat> tezTaskIdFormat = new ThreadLocal<FastNumberFormat>(){

        @Override
        public FastNumberFormat initialValue() {
            FastNumberFormat fmt = FastNumberFormat.getInstance();
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };
    private static TezID.TezIDCache<TezTaskID> tezTaskIDCache = new TezID.TezIDCache();
    private TezVertexID vertexId;

    public static TezTaskID getInstance(TezVertexID vertexID, int id) {
        Preconditions.checkArgument((vertexID != null ? 1 : 0) != 0, (Object)"vertexID cannot be null");
        return tezTaskIDCache.getInstance(new TezTaskID(vertexID, id));
    }

    @InterfaceAudience.Private
    public static void clearCache() {
        tezTaskIDCache.clear();
    }

    private TezTaskID(TezVertexID vertexID, int id) {
        super(id);
        Preconditions.checkArgument((vertexID != null ? 1 : 0) != 0, (Object)"vertexID cannot be null");
        this.vertexId = vertexID;
        this.serializingHash = this.getHashCode(true);
    }

    public int getSerializingHash() {
        return this.serializingHash;
    }

    public TezVertexID getVertexID() {
        return this.vertexId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TezTaskID that = (TezTaskID)o;
        return this.vertexId.equals(that.vertexId);
    }

    @Override
    public int compareTo(TezID o) {
        TezTaskID that = (TezTaskID)o;
        int vertexComp = this.vertexId.compareTo(that.vertexId);
        if (vertexComp == 0) {
            return this.id - that.id;
        }
        return vertexComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(TASK)).toString();
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        this.vertexId.appendTo(builder);
        builder.append('_');
        return tezTaskIdFormat.get().format(this.id, builder);
    }

    @Override
    public int hashCode() {
        return this.getHashCode(false);
    }

    public int getHashCode(boolean makePositive) {
        int code = this.vertexId.hashCode() * 535013 + this.id;
        if (makePositive) {
            code = code < 0 ? -code : code;
        }
        return code;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.vertexId = TezVertexID.readTezVertexID(in);
        super.readFields(in);
    }

    public static TezTaskID readTezTaskID(DataInput in) throws IOException {
        TezVertexID vertexID = TezVertexID.readTezVertexID(in);
        int taskIdInt = TezID.readID(in);
        return TezTaskID.getInstance(vertexID, taskIdInt);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.vertexId.write(out);
        super.write(out);
    }

    public static TezTaskID fromString(String taskIdStr) {
        try {
            int pos1 = taskIdStr.indexOf(95);
            int pos2 = taskIdStr.indexOf(95, pos1 + 1);
            int pos3 = taskIdStr.indexOf(95, pos2 + 1);
            int pos4 = taskIdStr.indexOf(95, pos3 + 1);
            int pos5 = taskIdStr.indexOf(95, pos4 + 1);
            String rmId = taskIdStr.substring(pos1 + 1, pos2);
            int appId = Integer.parseInt(taskIdStr.substring(pos2 + 1, pos3));
            int dagId = Integer.parseInt(taskIdStr.substring(pos3 + 1, pos4));
            int vId = Integer.parseInt(taskIdStr.substring(pos4 + 1, pos5));
            int id = Integer.parseInt(taskIdStr.substring(pos5 + 1));
            return TezTaskID.getInstance(TezVertexID.getInstance(TezDAGID.getInstance(rmId, appId, dagId), vId), id);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

