/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.SslRMIClientSocketFactorySecure;
import org.apache.hadoop.hbase.SslRMIServerSocketFactorySecure;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;

public class JMXListener
implements Coprocessor {
    private static final Log LOG = LogFactory.getLog(JMXListener.class);
    public static final String RMI_REGISTRY_PORT_CONF_KEY = ".rmi.registry.port";
    public static final String RMI_CONNECTOR_PORT_CONF_KEY = ".rmi.connector.port";
    public static final int defMasterRMIRegistryPort = 10101;
    public static final int defRegionserverRMIRegistryPort = 10102;
    private static JMXConnectorServer JMX_CS = null;
    private Registry rmiRegistry = null;

    public static JMXServiceURL buildJMXServiceURL(int rmiRegistryPort, int rmiConnectorPort) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append("service:jmx:rmi://localhost:");
        url.append(rmiConnectorPort);
        url.append("/jndi/rmi://localhost:");
        url.append(rmiRegistryPort);
        url.append("/jmxrmi");
        return new JMXServiceURL(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startConnectorServer(int rmiRegistryPort, int rmiConnectorPort) throws IOException {
        boolean rmiSSL = false;
        boolean authenticate = true;
        String passwordFile = null;
        String accessFile = null;
        System.setProperty("java.rmi.server.randomIDs", "true");
        String rmiSSLValue = System.getProperty("com.sun.management.jmxremote.ssl", "false");
        rmiSSL = Boolean.parseBoolean(rmiSSLValue);
        String authenticateValue = System.getProperty("com.sun.management.jmxremote.authenticate", "false");
        authenticate = Boolean.parseBoolean(authenticateValue);
        passwordFile = System.getProperty("com.sun.management.jmxremote.password.file");
        accessFile = System.getProperty("com.sun.management.jmxremote.access.file");
        LOG.info((Object)("rmiSSL:" + rmiSSLValue + ",authenticate:" + authenticateValue + ",passwordFile:" + passwordFile + ",accessFile:" + accessFile));
        HashMap<String, Object> jmxEnv = new HashMap<String, Object>();
        SslRMIClientSocketFactorySecure csf = null;
        SslRMIServerSocketFactorySecure ssf = null;
        if (rmiSSL) {
            if (rmiRegistryPort == rmiConnectorPort) {
                throw new IOException("SSL is enabled. rmiConnectorPort cannot share with the rmiRegistryPort!");
            }
            csf = new SslRMIClientSocketFactorySecure();
            ssf = new SslRMIServerSocketFactorySecure();
        }
        if (csf != null) {
            jmxEnv.put("jmx.remote.rmi.client.socket.factory", csf);
        }
        if (ssf != null) {
            jmxEnv.put("jmx.remote.rmi.server.socket.factory", ssf);
        }
        if (authenticate) {
            jmxEnv.put("jmx.remote.x.password.file", passwordFile);
            jmxEnv.put("jmx.remote.x.access.file", accessFile);
        }
        this.rmiRegistry = LocateRegistry.createRegistry(rmiRegistryPort);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JMXServiceURL serviceUrl = JMXListener.buildJMXServiceURL(rmiRegistryPort, rmiConnectorPort);
        try {
            Class<JMXListener> clazz = JMXListener.class;
            synchronized (JMXListener.class) {
                if (JMX_CS != null) {
                    throw new RuntimeException("Started by another thread?");
                }
                JMX_CS = JMXConnectorServerFactory.newJMXConnectorServer(serviceUrl, jmxEnv, mbs);
                JMX_CS.start();
                // ** MonitorExit[var14_14] (shouldn't be in output)
                LOG.info((Object)"ConnectorServer started!");
                return;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"fail to start connector server!", (Throwable)e);
            if (this.rmiRegistry == null) return;
            UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnectorServer() throws IOException {
        Class<JMXListener> clazz = JMXListener.class;
        synchronized (JMXListener.class) {
            if (JMX_CS != null) {
                JMX_CS.stop();
                LOG.info((Object)"ConnectorServer stopped!");
                JMX_CS = null;
            }
            if (this.rmiRegistry != null) {
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(CoprocessorEnvironment env) throws IOException {
        int rmiRegistryPort = -1;
        int rmiConnectorPort = -1;
        Configuration conf = env.getConfiguration();
        if (env instanceof MasterCoprocessorEnvironment) {
            rmiRegistryPort = conf.getInt("master.rmi.registry.port", 10101);
            rmiConnectorPort = conf.getInt("master.rmi.connector.port", rmiRegistryPort);
            LOG.info((Object)("Master rmiRegistryPort:" + rmiRegistryPort + ",Master rmiConnectorPort:" + rmiConnectorPort));
        } else if (env instanceof RegionServerCoprocessorEnvironment) {
            rmiRegistryPort = conf.getInt("regionserver.rmi.registry.port", 10102);
            rmiConnectorPort = conf.getInt("regionserver.rmi.connector.port", rmiRegistryPort);
            LOG.info((Object)("RegionServer rmiRegistryPort:" + rmiRegistryPort + ",RegionServer rmiConnectorPort:" + rmiConnectorPort));
        } else if (env instanceof RegionCoprocessorEnvironment) {
            LOG.error((Object)"JMXListener should not be loaded in Region Environment!");
            return;
        }
        Class<JMXListener> clazz = JMXListener.class;
        synchronized (JMXListener.class) {
            if (JMX_CS != null) {
                LOG.info((Object)("JMXListener has been started at Registry port " + rmiRegistryPort));
            } else {
                this.startConnectorServer(rmiRegistryPort, rmiConnectorPort);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
        this.stopConnectorServer();
    }
}

