/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.ClientServiceDelegate;
import org.apache.hadoop.mapred.ResourceMgrDelegate;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetCountersResponse;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportRequest;
import org.apache.hadoop.mapreduce.v2.api.protocolrecords.GetJobReportResponse;
import org.apache.hadoop.mapreduce.v2.api.records.Counter;
import org.apache.hadoop.mapreduce.v2.api.records.CounterGroup;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class TestClientServiceDelegate {
    private JobID oldJobId = JobID.forName((String)"job_1315895242400_2");
    private JobId jobId = TypeConverter.toYarn((JobID)this.oldJobId);
    private boolean isAMReachableFromClient;

    public TestClientServiceDelegate(boolean isAMReachableFromClient) {
        this.isAMReachableFromClient = isAMReachableFromClient;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{true}, {false}};
        return Arrays.asList(data);
    }

    @Test
    public void testUnknownAppInRM() throws Exception {
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport(this.getJobReportRequest())).thenReturn((Object)this.getJobReportResponse());
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(historyServerProxy, this.getRMDelegate());
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
    }

    @Test
    public void testRemoteExceptionFromHistoryServer() throws Exception {
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport(this.getJobReportRequest())).thenThrow(new Throwable[]{new IOException("Job ID doesnot Exist")});
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn(null);
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(historyServerProxy, rm);
        try {
            clientServiceDelegate.getJobStatus(this.oldJobId);
            Assert.fail((String)"Invoke should throw exception after retries.");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Job ID doesnot Exist"));
        }
    }

    @Test
    public void testRetriesOnConnectionFailure() throws Exception {
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport(this.getJobReportRequest())).thenThrow(new Throwable[]{new RuntimeException("1")}).thenThrow(new Throwable[]{new RuntimeException("2")}).thenReturn((Object)this.getJobReportResponse());
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn(null);
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(historyServerProxy, rm);
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        ((MRClientProtocol)Mockito.verify((Object)historyServerProxy, (VerificationMode)Mockito.times((int)3))).getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class));
    }

    @Test
    public void testRetriesOnAMConnectionFailures() throws Exception {
        if (!this.isAMReachableFromClient) {
            return;
        }
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn((Object)this.getRunningApplicationReport("am1", 78));
        final MRClientProtocol amProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)amProxy.getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class))).thenThrow(new Throwable[]{new RuntimeException("11")}).thenThrow(new Throwable[]{new RuntimeException("22")}).thenThrow(new Throwable[]{new RuntimeException("33")}).thenThrow(new Throwable[]{new RuntimeException("44")}).thenReturn((Object)this.getJobReportResponse());
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.setBoolean("mapreduce.job.am-access-disabled", !this.isAMReachableFromClient);
        ClientServiceDelegate clientServiceDelegate = new ClientServiceDelegate((Configuration)conf, rm, this.oldJobId, null){

            MRClientProtocol instantiateAMProxy(InetSocketAddress serviceAddr) throws IOException {
                super.instantiateAMProxy(serviceAddr);
                return amProxy;
            }
        };
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((long)conf.getInt("yarn.app.mapreduce.client.max-retries", 3), (long)clientServiceDelegate.getMaxClientRetry());
        ((MRClientProtocol)Mockito.verify((Object)amProxy, (VerificationMode)Mockito.times((int)5))).getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class));
    }

    @Test
    public void testNoRetryOnAMAuthorizationException() throws Exception {
        if (!this.isAMReachableFromClient) {
            return;
        }
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn((Object)this.getRunningApplicationReport("am1", 78));
        final MRClientProtocol amProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)amProxy.getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class))).thenThrow(new Throwable[]{new AuthorizationException("Denied")});
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.setBoolean("mapreduce.job.am-access-disabled", !this.isAMReachableFromClient);
        ClientServiceDelegate clientServiceDelegate = new ClientServiceDelegate((Configuration)conf, rm, this.oldJobId, null){

            MRClientProtocol instantiateAMProxy(InetSocketAddress serviceAddr) throws IOException {
                super.instantiateAMProxy(serviceAddr);
                return amProxy;
            }
        };
        try {
            clientServiceDelegate.getJobStatus(this.oldJobId);
            Assert.fail((String)"Exception should be thrown upon AuthorizationException");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)(AuthorizationException.class.getName() + ": Denied"), (Object)e.getMessage());
        }
        Assert.assertEquals((long)conf.getInt("yarn.app.mapreduce.client.max-retries", 3), (long)clientServiceDelegate.getMaxClientRetry());
        ((MRClientProtocol)Mockito.verify((Object)amProxy, (VerificationMode)Mockito.times((int)1))).getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class));
    }

    @Test
    public void testHistoryServerNotConfigured() throws Exception {
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(null, this.getRMDelegate());
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertEquals((Object)"N/A", (Object)jobStatus.getUsername());
        Assert.assertEquals((Object)JobStatus.State.PREP, (Object)jobStatus.getState());
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        ApplicationReport applicationReport = this.getFinishedApplicationReport();
        Mockito.when((Object)rm.getApplicationReport(this.jobId.getAppId())).thenReturn((Object)applicationReport);
        clientServiceDelegate = this.getClientServiceDelegate(null, rm);
        jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertEquals((Object)applicationReport.getUser(), (Object)jobStatus.getUsername());
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)jobStatus.getState());
    }

    @Test
    public void testJobReportFromHistoryServer() throws Exception {
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport(this.getJobReportRequest())).thenReturn((Object)this.getJobReportResponseFromHistoryServer());
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn(null);
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(historyServerProxy, rm);
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"TestJobFilePath", (Object)jobStatus.getJobFile());
        Assert.assertEquals((Object)"http://TestTrackingUrl", (Object)jobStatus.getTrackingUrl());
        Assert.assertEquals((float)1.0f, (float)jobStatus.getMapProgress(), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)jobStatus.getReduceProgress(), (float)0.0f);
    }

    @Test
    public void testCountersFromHistoryServer() throws Exception {
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getCounters(this.getCountersRequest())).thenReturn((Object)this.getCountersResponseFromHistoryServer());
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        Mockito.when((Object)rm.getApplicationReport(TypeConverter.toYarn((JobID)this.oldJobId).getAppId())).thenReturn(null);
        ClientServiceDelegate clientServiceDelegate = this.getClientServiceDelegate(historyServerProxy, rm);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = TypeConverter.toYarn((Counters)clientServiceDelegate.getJobCounters(this.oldJobId));
        Assert.assertNotNull((Object)counters);
        Assert.assertEquals((long)1001L, (long)counters.getCounterGroup("dummyCounters").getCounter("dummyCounter").getValue());
    }

    @Test
    public void testReconnectOnAMRestart() throws IOException {
        if (!this.isAMReachableFromClient) {
            return;
        }
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        try {
            Mockito.when((Object)rmDelegate.getApplicationReport(this.jobId.getAppId())).thenReturn((Object)this.getRunningApplicationReport("am1", 78)).thenReturn((Object)this.getRunningApplicationReport(null, 0)).thenReturn((Object)this.getRunningApplicationReport(null, 0)).thenReturn((Object)this.getRunningApplicationReport("am2", 90));
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        GetJobReportResponse jobReportResponse1 = (GetJobReportResponse)Mockito.mock(GetJobReportResponse.class);
        Mockito.when((Object)jobReportResponse1.getJobReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)this.jobId, (String)"jobName-firstGen", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"anything", null, (boolean)false, (String)""));
        MRClientProtocol firstGenAMProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)firstGenAMProxy.getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class))).thenReturn((Object)jobReportResponse1).thenThrow(new Throwable[]{new RuntimeException("AM is down!")});
        GetJobReportResponse jobReportResponse2 = (GetJobReportResponse)Mockito.mock(GetJobReportResponse.class);
        Mockito.when((Object)jobReportResponse2.getJobReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)this.jobId, (String)"jobName-secondGen", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"anything", null, (boolean)false, (String)""));
        MRClientProtocol secondGenAMProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)secondGenAMProxy.getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class))).thenReturn((Object)jobReportResponse2);
        ClientServiceDelegate clientServiceDelegate = (ClientServiceDelegate)Mockito.spy((Object)this.getClientServiceDelegate(historyServerProxy, rmDelegate));
        ((ClientServiceDelegate)Mockito.doReturn((Object)firstGenAMProxy).doReturn((Object)secondGenAMProxy).when((Object)clientServiceDelegate)).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"jobName-firstGen", (Object)jobStatus.getJobName());
        jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"jobName-secondGen", (Object)jobStatus.getJobName());
        jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"jobName-secondGen", (Object)jobStatus.getJobName());
        ((ClientServiceDelegate)Mockito.verify((Object)clientServiceDelegate, (VerificationMode)Mockito.times((int)2))).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
    }

    @Test
    public void testAMAccessDisabled() throws IOException {
        if (this.isAMReachableFromClient) {
            return;
        }
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport(this.getJobReportRequest())).thenReturn((Object)this.getJobReportResponseFromHistoryServer());
        ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        try {
            Mockito.when((Object)rmDelegate.getApplicationReport(this.jobId.getAppId())).thenReturn((Object)this.getRunningApplicationReport("am1", 78)).thenReturn((Object)this.getRunningApplicationReport("am1", 78)).thenReturn((Object)this.getRunningApplicationReport("am1", 78)).thenReturn((Object)this.getFinishedApplicationReport());
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        ClientServiceDelegate clientServiceDelegate = (ClientServiceDelegate)Mockito.spy((Object)this.getClientServiceDelegate(historyServerProxy, rmDelegate));
        JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"N/A", (Object)jobStatus.getJobName());
        ((ClientServiceDelegate)Mockito.verify((Object)clientServiceDelegate, (VerificationMode)Mockito.times((int)0))).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
        jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"N/A", (Object)jobStatus.getJobName());
        ((ClientServiceDelegate)Mockito.verify((Object)clientServiceDelegate, (VerificationMode)Mockito.times((int)0))).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
        jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus);
        Assert.assertEquals((Object)"N/A", (Object)jobStatus.getJobName());
        ((ClientServiceDelegate)Mockito.verify((Object)clientServiceDelegate, (VerificationMode)Mockito.times((int)0))).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
        JobStatus jobStatus1 = clientServiceDelegate.getJobStatus(this.oldJobId);
        Assert.assertNotNull((Object)jobStatus1);
        Assert.assertEquals((Object)"TestJobFilePath", (Object)jobStatus1.getJobFile());
        Assert.assertEquals((Object)"http://TestTrackingUrl", (Object)jobStatus1.getTrackingUrl());
        Assert.assertEquals((float)1.0f, (float)jobStatus1.getMapProgress(), (float)0.0f);
        Assert.assertEquals((float)1.0f, (float)jobStatus1.getReduceProgress(), (float)0.0f);
        ((ClientServiceDelegate)Mockito.verify((Object)clientServiceDelegate, (VerificationMode)Mockito.times((int)0))).instantiateAMProxy((InetSocketAddress)Matchers.any(InetSocketAddress.class));
    }

    @Test
    public void testRMDownForJobStatusBeforeGetAMReport() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        this.testRMDownForJobStatusBeforeGetAMReport((Configuration)conf, 3);
    }

    @Test
    public void testRMDownForJobStatusBeforeGetAMReportWithRetryTimes() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.app.mapreduce.client.max-retries", 2);
        this.testRMDownForJobStatusBeforeGetAMReport((Configuration)conf, conf.getInt("yarn.app.mapreduce.client.max-retries", 3));
    }

    @Test
    public void testRMDownRestoreForJobStatusBeforeGetAMReport() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.app.mapreduce.client.max-retries", 3);
        conf.set("mapreduce.framework.name", "yarn");
        conf.setBoolean("mapreduce.job.am-access-disabled", !this.isAMReachableFromClient);
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        Mockito.when((Object)historyServerProxy.getJobReport((GetJobReportRequest)Matchers.any(GetJobReportRequest.class))).thenReturn((Object)this.getJobReportResponse());
        ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        try {
            Mockito.when((Object)rmDelegate.getApplicationReport(this.jobId.getAppId())).thenThrow(new Throwable[]{new UndeclaredThrowableException(new IOException("Connection refuced1"))}).thenThrow(new Throwable[]{new UndeclaredThrowableException(new IOException("Connection refuced2"))}).thenReturn((Object)this.getFinishedApplicationReport());
            ClientServiceDelegate clientServiceDelegate = new ClientServiceDelegate((Configuration)conf, rmDelegate, this.oldJobId, historyServerProxy);
            JobStatus jobStatus = clientServiceDelegate.getJobStatus(this.oldJobId);
            ((ResourceMgrDelegate)Mockito.verify((Object)rmDelegate, (VerificationMode)Mockito.times((int)3))).getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class));
            Assert.assertNotNull((Object)jobStatus);
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    private void testRMDownForJobStatusBeforeGetAMReport(Configuration conf, int noOfRetries) throws IOException {
        conf.set("mapreduce.framework.name", "yarn");
        conf.setBoolean("mapreduce.job.am-access-disabled", !this.isAMReachableFromClient);
        MRClientProtocol historyServerProxy = (MRClientProtocol)Mockito.mock(MRClientProtocol.class);
        ResourceMgrDelegate rmDelegate = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        try {
            Mockito.when((Object)rmDelegate.getApplicationReport(this.jobId.getAppId())).thenThrow(new Throwable[]{new UndeclaredThrowableException(new IOException("Connection refuced1"))}).thenThrow(new Throwable[]{new UndeclaredThrowableException(new IOException("Connection refuced2"))}).thenThrow(new Throwable[]{new UndeclaredThrowableException(new IOException("Connection refuced3"))});
            ClientServiceDelegate clientServiceDelegate = new ClientServiceDelegate(conf, rmDelegate, this.oldJobId, historyServerProxy);
            try {
                clientServiceDelegate.getJobStatus(this.oldJobId);
                Assert.fail((String)"It should throw exception after retries");
            }
            catch (IOException e) {
                System.out.println("fail to get job status,and e=" + e.toString());
            }
            ((ResourceMgrDelegate)Mockito.verify((Object)rmDelegate, (VerificationMode)Mockito.times((int)noOfRetries))).getApplicationReport((ApplicationId)Matchers.any(ApplicationId.class));
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
    }

    private GetJobReportRequest getJobReportRequest() {
        GetJobReportRequest request = (GetJobReportRequest)Records.newRecord(GetJobReportRequest.class);
        request.setJobId(this.jobId);
        return request;
    }

    private GetJobReportResponse getJobReportResponse() {
        GetJobReportResponse jobReportResponse = (GetJobReportResponse)Records.newRecord(GetJobReportResponse.class);
        JobReport jobReport = (JobReport)Records.newRecord(JobReport.class);
        jobReport.setJobId(this.jobId);
        jobReport.setJobState(JobState.SUCCEEDED);
        jobReportResponse.setJobReport(jobReport);
        return jobReportResponse;
    }

    private GetCountersRequest getCountersRequest() {
        GetCountersRequest request = (GetCountersRequest)Records.newRecord(GetCountersRequest.class);
        request.setJobId(this.jobId);
        return request;
    }

    private ApplicationReport getFinishedApplicationReport() {
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        return ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)attemptId, (String)"user", (String)"queue", (String)"appname", (String)"host", (int)124, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, null, (String)"N/A", (float)0.0f, (String)"YARN", null);
    }

    private ApplicationReport getRunningApplicationReport(String host, int port) {
        ApplicationId appId = ApplicationId.newInstance((long)1234L, (int)5);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        return ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)attemptId, (String)"user", (String)"queue", (String)"appname", (String)host, (int)port, null, (YarnApplicationState)YarnApplicationState.RUNNING, (String)"diagnostics", (String)"url", (long)0L, (long)0L, (long)0L, (FinalApplicationStatus)FinalApplicationStatus.UNDEFINED, null, (String)"N/A", (float)0.0f, (String)"YARN", null);
    }

    private ResourceMgrDelegate getRMDelegate() throws IOException {
        ResourceMgrDelegate rm = (ResourceMgrDelegate)Mockito.mock(ResourceMgrDelegate.class);
        try {
            ApplicationId appId = this.jobId.getAppId();
            Mockito.when((Object)rm.getApplicationReport(appId)).thenThrow(new Throwable[]{new ApplicationNotFoundException(appId + " not found")});
        }
        catch (YarnException e) {
            throw new IOException(e);
        }
        return rm;
    }

    private ClientServiceDelegate getClientServiceDelegate(MRClientProtocol historyServerProxy, ResourceMgrDelegate rm) {
        YarnConfiguration conf = new YarnConfiguration();
        conf.set("mapreduce.framework.name", "yarn");
        conf.setBoolean("mapreduce.job.am-access-disabled", !this.isAMReachableFromClient);
        ClientServiceDelegate clientServiceDelegate = new ClientServiceDelegate((Configuration)conf, rm, this.oldJobId, historyServerProxy);
        return clientServiceDelegate;
    }

    private GetJobReportResponse getJobReportResponseFromHistoryServer() {
        GetJobReportResponse jobReportResponse = (GetJobReportResponse)Records.newRecord(GetJobReportResponse.class);
        JobReport jobReport = (JobReport)Records.newRecord(JobReport.class);
        jobReport.setJobId(this.jobId);
        jobReport.setJobState(JobState.SUCCEEDED);
        jobReport.setMapProgress(1.0f);
        jobReport.setReduceProgress(1.0f);
        jobReport.setJobFile("TestJobFilePath");
        jobReport.setTrackingUrl("http://TestTrackingUrl");
        jobReportResponse.setJobReport(jobReport);
        return jobReportResponse;
    }

    private GetCountersResponse getCountersResponseFromHistoryServer() {
        GetCountersResponse countersResponse = (GetCountersResponse)Records.newRecord(GetCountersResponse.class);
        Counter counter = (Counter)Records.newRecord(Counter.class);
        CounterGroup counterGroup = (CounterGroup)Records.newRecord(CounterGroup.class);
        org.apache.hadoop.mapreduce.v2.api.records.Counters counters = (org.apache.hadoop.mapreduce.v2.api.records.Counters)Records.newRecord(org.apache.hadoop.mapreduce.v2.api.records.Counters.class);
        counter.setDisplayName("dummyCounter");
        counter.setName("dummyCounter");
        counter.setValue(1001L);
        counterGroup.setName("dummyCounters");
        counterGroup.setDisplayName("dummyCounters");
        counterGroup.setCounter("dummyCounter", counter);
        counters.setCounterGroup("dummyCounters", counterGroup);
        countersResponse.setCounters(counters);
        return countersResponse;
    }
}

