/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.DefaultFetchFormatter;
import org.apache.hadoop.hive.ql.exec.FetchFormatter;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.util.ReflectionUtils;

public class ListSinkOperator
extends Operator<ListSinkDesc> {
    public static final String OUTPUT_FORMATTER = "output.formatter";
    public static final String OUTPUT_PROTOCOL = "output.protocol";
    private transient List res;
    private transient FetchFormatter fetcher;
    private transient int numRows;

    @Override
    protected Collection<Future<?>> initializeOp(Configuration hconf) throws HiveException {
        Collection<Future<?>> result = super.initializeOp(hconf);
        try {
            this.fetcher = this.initializeFetcher(hconf);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return result;
    }

    private FetchFormatter initializeFetcher(Configuration conf) throws Exception {
        FetchFormatter<String> fetcher;
        String formatterName = conf.get(OUTPUT_FORMATTER);
        if (formatterName != null && !formatterName.isEmpty()) {
            Class<FetchFormatter> fetcherClass = Class.forName(formatterName, true, Utilities.getSessionSpecifiedClassLoader()).asSubclass(FetchFormatter.class);
            fetcher = (FetchFormatter)ReflectionUtils.newInstance(fetcherClass, null);
        } else {
            fetcher = new DefaultFetchFormatter();
        }
        Properties props = new Properties();
        props.put("serialization.format", "9");
        props.put("serialization.null.format", ((ListSinkDesc)this.getConf()).getSerializationNullFormat());
        fetcher.initialize(conf, props);
        return fetcher;
    }

    public void reset(List res) {
        this.res = res;
        this.numRows = 0;
    }

    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        try {
            this.res.add(this.fetcher.convert(row, this.inputObjInspectors[0]));
            ++this.numRows;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FORWARD;
    }
}

