/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterDoubleColLessEqualDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;

    public FilterDoubleColLessEqualDoubleColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterDoubleColLessEqualDoubleColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector1 = (DoubleColumnVector)batch.cols[this.colNum1];
        DoubleColumnVector inputColVector2 = (DoubleColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        int n = batch.size;
        double[] vector1 = inputColVector1.vector;
        double[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        int newSize = NullUtil.filterNulls(batch.cols[this.colNum1], batch.selectedInUse, sel, n);
        if (newSize < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if ((newSize = NullUtil.filterNulls(batch.cols[this.colNum2], batch.selectedInUse, sel, n)) < n) {
            n = batch.size = newSize;
            batch.selectedInUse = true;
        }
        if (n != 0 && inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (!(vector1[0] <= vector2[0])) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!(vector1[0] <= vector2[i])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!(vector1[0] <= vector2[i])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (!(vector1[i] <= vector2[0])) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (!(vector1[i] <= vector2[0])) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!(vector1[i] <= vector2[i])) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (!(vector1[i] <= vector2[i])) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    public int getColNum1() {
        return this.colNum1;
    }

    public void setColNum1(int colNum1) {
        this.colNum1 = colNum1;
    }

    public int getColNum2() {
        return this.colNum2;
    }

    public void setColNum2(int colNum2) {
        this.colNum2 = colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

