/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Reporter;

public interface AcidOutputFormat<K extends WritableComparable, V>
extends HiveOutputFormat<K, V> {
    public RecordUpdater getRecordUpdater(Path var1, Options var2) throws IOException;

    public FileSinkOperator.RecordWriter getRawRecordWriter(Path var1, Options var2) throws IOException;

    public static class Options {
        private final Configuration configuration;
        private FileSystem fs;
        private ObjectInspector inspector;
        private boolean writingBase = false;
        private boolean isCompressed = false;
        private Properties properties;
        private Reporter reporter;
        private long minimumTransactionId;
        private long maximumTransactionId;
        private int bucket;
        private PrintStream dummyStream = null;
        private boolean oldStyle = false;
        private int recIdCol = -1;

        public Options(Configuration conf) {
            this.configuration = conf;
        }

        public Options inspector(ObjectInspector inspector) {
            this.inspector = inspector;
            return this;
        }

        public Options writingBase(boolean val) {
            this.writingBase = val;
            return this;
        }

        public Options filesystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        public Options isCompressed(boolean isCompressed) {
            this.isCompressed = isCompressed;
            return this;
        }

        public Options tableProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Options reporter(Reporter reporter) {
            this.reporter = reporter;
            return this;
        }

        public Options minimumTransactionId(long min) {
            this.minimumTransactionId = min;
            return this;
        }

        public Options maximumTransactionId(long max) {
            this.maximumTransactionId = max;
            return this;
        }

        public Options bucket(int bucket) {
            this.bucket = bucket;
            return this;
        }

        Options setOldStyle(boolean value) {
            this.oldStyle = value;
            return this;
        }

        public Options recordIdColumn(int recIdCol) {
            this.recIdCol = recIdCol;
            return this;
        }

        public Options useDummy(PrintStream stream) {
            this.dummyStream = stream;
            return this;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public FileSystem getFilesystem() {
            return this.fs;
        }

        public ObjectInspector getInspector() {
            return this.inspector;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public Properties getTableProperties() {
            return this.properties;
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public long getMinimumTransactionId() {
            return this.minimumTransactionId;
        }

        public long getMaximumTransactionId() {
            return this.maximumTransactionId;
        }

        public boolean isWritingBase() {
            return this.writingBase;
        }

        public int getBucket() {
            return this.bucket;
        }

        public int getRecordIdColumn() {
            return this.recIdCol;
        }

        public PrintStream getDummyStream() {
            return this.dummyStream;
        }

        boolean getOldStyle() {
            return this.oldStyle;
        }
    }
}

