/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewFsLinkFallback {
    private static FileSystem fsDefault;
    private FileSystem fsTarget;
    private static MiniDFSCluster cluster;
    private static URI viewFsDefaultClusterUri;
    private Path targetTestRoot;

    @BeforeClass
    public static void clusterSetupAtBeginning() throws IOException, URISyntaxException {
        int nameSpacesCount = 3;
        int dataNodesCount = 3;
        int fsIndexDefault = 0;
        Configuration conf = new Configuration();
        FileSystem[] fsHdfs = new FileSystem[nameSpacesCount];
        conf.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(nameSpacesCount)).numDataNodes(dataNodesCount).build();
        cluster.waitClusterUp();
        for (int i = 0; i < nameSpacesCount; ++i) {
            fsHdfs[i] = cluster.getFileSystem(i);
        }
        fsDefault = fsHdfs[fsIndexDefault];
        viewFsDefaultClusterUri = new URI("viewfs", "default", "/", null, null);
    }

    @AfterClass
    public static void clusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fsTarget = fsDefault;
        this.initializeTargetTestRoot();
    }

    private void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = fsDefault.makeQualified(new Path("/"));
        for (FileStatus status : fsDefault.listStatus(this.targetTestRoot)) {
            fsDefault.delete(status.getPath(), true);
        }
    }

    @Test
    public void testGetDelegationToken() throws IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user", (URI)new Path(this.targetTestRoot.toString(), "user").toUri());
        ConfigUtil.addLink((Configuration)conf, (String)"/data", (URI)new Path(this.targetTestRoot.toString(), "data").toUri());
        ConfigUtil.addLinkFallback((Configuration)conf, (URI)this.targetTestRoot.toUri());
        FileContext fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        List tokens = fcView.getDelegationTokens(new Path("/"), "tester");
        Assert.assertEquals((long)3L, (long)tokens.size());
    }
}

