/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestBlockReportLease {
    private static final Log LOG = LogFactory.getLog(TestBlockReportLease.class);

    @Test
    public void testCheckBlockReportLease() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Random rand = new Random();
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();){
            cluster.waitActive();
            FSNamesystem fsn = cluster.getNamesystem();
            BlockManager blockManager = fsn.getBlockManager();
            BlockManager spyBlockManager = (BlockManager)Mockito.spy((Object)blockManager);
            fsn.setBlockManagerForTesting(spyBlockManager);
            final String poolId = cluster.getNamesystem().getBlockPoolId();
            final NamenodeProtocols rpcServer = cluster.getNameNodeRpc();
            DataNode dn = cluster.getDataNodes().get(0);
            DatanodeDescriptor datanodeDescriptor = spyBlockManager.getDatanodeManager().getDatanode(dn.getDatanodeId());
            final DatanodeRegistration dnRegistration = dn.getDNRegistrationForBP(poolId);
            final StorageReport[] storages = dn.getFSDataset().getStorageReports(poolId);
            HeartbeatResponse hbResponse = rpcServer.sendHeartbeat(dnRegistration, storages, 0L, 0L, 0, 0, 0, null, true, SlowPeerReports.EMPTY_REPORT, SlowDiskReports.EMPTY_REPORT);
            GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
            ((BlockManager)Mockito.doAnswer((Answer)delayer).when((Object)spyBlockManager)).processReport((DatanodeStorageInfo)Matchers.any(DatanodeStorageInfo.class), (BlockListAsLongs)Matchers.any(BlockListAsLongs.class), (BlockReportContext)Matchers.any(BlockReportContext.class));
            ExecutorService pool = Executors.newFixedThreadPool(1);
            final BlockReportContext brContext = new BlockReportContext(1, 0, rand.nextLong(), hbResponse.getFullBlockReportLeaseId());
            Future<DatanodeCommand> sendBRfuturea = pool.submit(new Callable<DatanodeCommand>(){

                @Override
                public DatanodeCommand call() throws Exception {
                    DatanodeStorage[] datanodeStorages = new DatanodeStorage[storages.length];
                    for (int i = 0; i < storages.length; ++i) {
                        datanodeStorages[i] = storages[i].getStorage();
                    }
                    StorageBlockReport[] reports = TestBlockReportLease.this.createReports(datanodeStorages, 100);
                    return rpcServer.blockReport(dnRegistration, poolId, reports, brContext);
                }
            });
            delayer.waitForCall();
            spyBlockManager.getBlockReportLeaseManager().removeLease(datanodeDescriptor);
            delayer.proceed();
            DatanodeCommand datanodeCommand = sendBRfuturea.get();
            Assert.assertTrue((boolean)(datanodeCommand instanceof FinalizeCommand));
            Assert.assertEquals((Object)poolId, (Object)((FinalizeCommand)datanodeCommand).getBlockPoolId());
        }
    }

    private StorageBlockReport[] createReports(DatanodeStorage[] dnStorages, int numBlocks) {
        int longsPerBlock = 3;
        int blockListSize = 2 + numBlocks * longsPerBlock;
        int numStorages = dnStorages.length;
        StorageBlockReport[] storageBlockReports = new StorageBlockReport[numStorages];
        for (int i = 0; i < numStorages; ++i) {
            ArrayList<Long> longs = new ArrayList<Long>(blockListSize);
            longs.add(Long.valueOf(numBlocks));
            longs.add(0L);
            for (int j = 0; j < blockListSize; ++j) {
                longs.add(Long.valueOf(j));
            }
            BlockListAsLongs blockList = BlockListAsLongs.decodeLongs(longs);
            storageBlockReports[i] = new StorageBlockReport(dnStorages[i], blockList);
        }
        return storageBlockReports;
    }
}

