/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BloomMapFile;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.TestMapFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBloomMapFile {
    private static Configuration conf = new Configuration();
    private static final Path TEST_ROOT = new Path(GenericTestUtils.getTempPath(TestMapFile.class.getSimpleName()));
    private static final Path TEST_DIR = new Path(TEST_ROOT, "testfile");
    private static final Path TEST_FILE = new Path(TEST_ROOT, "testfile");
    static final Progressable defaultProgress = new Progressable(){

        public void progress() {
        }
    };
    static final CompressionCodec defaultCodec = new CompressionCodec(){

        public String getDefaultExtension() {
            return null;
        }

        public Class<? extends Decompressor> getDecompressorType() {
            return null;
        }

        public Class<? extends Compressor> getCompressorType() {
            return null;
        }

        public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
            return (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        }

        public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
            return null;
        }

        public CompressionInputStream createInputStream(InputStream in) throws IOException {
            return null;
        }

        public Decompressor createDecompressor() {
            return null;
        }

        public Compressor createCompressor() {
            return null;
        }
    };

    @Before
    public void setUp() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        if (fs.exists(TEST_ROOT) && !fs.delete(TEST_ROOT, true)) {
            Assert.fail((String)"Can't clean up test root dir");
        }
        fs.mkdirs(TEST_ROOT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMembershipTest() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(TEST_DIR);
        conf.setInt("io.mapfile.bloom.size", 2048);
        BloomMapFile.Writer writer = null;
        BloomMapFile.Reader reader = null;
        try {
            writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), IntWritable.class, Text.class);
            IntWritable key = new IntWritable();
            Text value = new Text();
            for (int i = 0; i < 2000; i += 2) {
                key.set(i);
                value.set("00" + i);
                writer.append((WritableComparable)key, (Writable)value);
            }
            writer.close();
            reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < 2000; ++i) {
                key.set(i);
                boolean exists = reader.probablyHasKey((WritableComparable)key);
                if (i % 2 == 0) {
                    if (exists) continue;
                    ++falseNeg;
                    continue;
                }
                if (!exists) continue;
                ++falsePos;
            }
            reader.close();
            fs.delete(qualifiedDirName, true);
            System.out.println("False negatives: " + falseNeg);
            Assert.assertEquals((long)0L, (long)falseNeg);
            System.out.println("False positives: " + falsePos);
            Assert.assertTrue((falsePos < 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMembershipVaryingSizedKeys(List<Text> keys) throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        Path qualifiedDirName = fs.makeQualified(TEST_DIR);
        BloomMapFile.Writer writer = null;
        BloomMapFile.Reader reader = null;
        try {
            writer = new BloomMapFile.Writer(conf, (FileSystem)fs, qualifiedDirName.toString(), Text.class, NullWritable.class);
            for (Text key : keys) {
                writer.append((WritableComparable)key, (Writable)NullWritable.get());
            }
            writer.close();
            reader = new BloomMapFile.Reader((FileSystem)fs, qualifiedDirName.toString(), conf);
            Collections.reverse(keys);
            for (Text key : keys) {
                Assert.assertTrue((String)("False negative for existing key " + key), (boolean)reader.probablyHasKey((WritableComparable)key));
            }
            reader.close();
            fs.delete(qualifiedDirName, true);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    @Test
    public void testMembershipVaryingSizedKeysTest1() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("A"));
        list.add(new Text("BB"));
        this.checkMembershipVaryingSizedKeys(list);
    }

    @Test
    public void testMembershipVaryingSizedKeysTest2() throws Exception {
        ArrayList<Text> list = new ArrayList<Text>();
        list.add(new Text("AA"));
        list.add(new Text("B"));
        this.checkMembershipVaryingSizedKeys(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteFile() {
        BloomMapFile.Writer writer = null;
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            Assert.assertNotNull((String)"testDeleteFile error !!!", (Object)writer);
            writer.close();
            BloomMapFile.delete((FileSystem)fs, (String)TEST_FILE.toString());
        }
        catch (Exception ex) {
            try {
                Assert.fail((String)"unexpect ex in testDeleteFile !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIOExceptionInWriterConstructor() {
        Path dirNameSpy = (Path)Mockito.spy((Object)TEST_FILE);
        BloomMapFile.Reader reader = null;
        BloomMapFile.Writer writer = null;
        try {
            writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            writer.append((WritableComparable)new IntWritable(1), (Writable)new Text("123124142"));
            writer.close();
            Mockito.when((Object)dirNameSpy.getFileSystem(conf)).thenThrow(new Throwable[]{new IOException()});
            reader = new BloomMapFile.Reader(dirNameSpy, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(IntWritable.class))});
            Assert.assertNull((String)"testIOExceptionInWriterConstructor error !!!", (Object)reader.getBloomFilter());
        }
        catch (Exception ex) {
            try {
                Assert.fail((String)"unexpect ex in testIOExceptionInWriterConstructor !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBloomMapFile() {
        int SIZE = 10;
        BloomMapFile.Reader reader = null;
        BloomMapFile.Writer writer = null;
        try {
            int i;
            writer = new BloomMapFile.Writer(conf, TEST_FILE, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(IntWritable.class), MapFile.Writer.valueClass(Text.class)});
            for (i = 0; i < SIZE; ++i) {
                writer.append((WritableComparable)new IntWritable(i), (Writable)new Text());
            }
            writer.close();
            reader = new BloomMapFile.Reader(TEST_FILE, conf, new SequenceFile.Reader.Option[]{MapFile.Reader.comparator((WritableComparator)new WritableComparator(IntWritable.class))});
            for (i = 0; i < SIZE; ++i) {
                Assert.assertNotNull((String)"testGetBloomMapFile error !!!", (Object)reader.get((WritableComparable)new IntWritable(i), (Writable)new Text()));
            }
            Assert.assertNull((String)"testGetBloomMapFile error !!!", (Object)reader.get((WritableComparable)new IntWritable(SIZE + 5), (Writable)new Text()));
        }
        catch (Exception ex) {
            try {
                Assert.fail((String)"unexpect ex in testGetBloomMapFile !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer, reader});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBloomMapFileConstructors() {
        BloomMapFile.Writer writer = null;
        try {
            FileSystem ts = FileSystem.get((Configuration)conf);
            String testFileName = TEST_FILE.toString();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultCodec, defaultProgress);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK, defaultProgress);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.BLOCK);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultCodec, defaultProgress);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD, defaultProgress);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, IntWritable.class, Text.class, SequenceFile.CompressionType.RECORD);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
            writer = new BloomMapFile.Writer(conf, ts, testFileName, WritableComparator.get(Text.class), Text.class);
            Assert.assertNotNull((String)"testBloomMapFileConstructors error !!!", (Object)writer);
            writer.close();
        }
        catch (Exception ex) {
            try {
                Assert.fail((String)"testBloomMapFileConstructors error !!!");
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
                throw throwable;
            }
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{writer});
    }
}

