/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MetricsCollectorImpl;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;
import org.apache.hadoop.metrics2.impl.MetricsSourceAdapter;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsAnnotations;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricsSourceBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestMetricsSourceAdapter {
    private static final int RACE_TEST_RUNTIME = 10000;

    @Test
    public void testPurgeOldMetrics() throws Exception {
        PurgableSource source = new PurgableSource();
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)source);
        MetricsSource s = sb.build();
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sa = new MetricsSourceAdapter("tst", "tst", "testdesc", s, injectedTags, null, null, 1L, false);
        MBeanInfo info = sa.getMBeanInfo();
        boolean sawIt = false;
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sawIt |= mBeanAttributeInfo.getName().equals(source.lastKeyName);
        }
        Assert.assertTrue((String)"The last generated metric is not exported to jmx", (boolean)sawIt);
        Thread.sleep(1000L);
        info = sa.getMBeanInfo();
        sawIt = false;
        for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
            sawIt |= mBeanAttributeInfo.getName().equals(source.lastKeyName);
        }
        Assert.assertTrue((String)"The last generated metric is not exported to jmx", (boolean)sawIt);
    }

    @Test
    public void testGetMetricsAndJmx() throws Exception {
        TestSource source = new TestSource("test");
        MetricsSourceBuilder sb = MetricsAnnotations.newSourceBuilder((Object)source);
        MetricsSource s = sb.build();
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sa = new MetricsSourceAdapter("test", "test", "test desc", s, injectedTags, null, null, 1L, false);
        MetricsCollectorImpl builder = new MetricsCollectorImpl();
        Iterable metricsRecords = sa.getMetrics(builder, true);
        MetricsRecordImpl metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertEquals((long)0L, (long)((AbstractMetric)metricsRecord.metrics().iterator().next()).value().longValue());
        Thread.sleep(100L);
        Assert.assertEquals((Object)0L, (Object)((Number)sa.getAttribute("C1")));
        source.incrementCnt();
        builder = new MetricsCollectorImpl();
        metricsRecords = sa.getMetrics(builder, true);
        metricsRecord = (MetricsRecordImpl)metricsRecords.iterator().next();
        Assert.assertTrue((boolean)metricsRecord.metrics().iterator().hasNext());
        Thread.sleep(100L);
        Assert.assertEquals((Object)1L, (Object)((Number)sa.getAttribute("C1")));
    }

    @Test
    public void testMetricCacheUpdateRace() throws Exception {
        TestMetricsSource source = new TestMetricsSource();
        MetricsSourceBuilder sourceBuilder = MetricsAnnotations.newSourceBuilder((Object)source);
        long JMX_CACHE_TTL = 250L;
        ArrayList injectedTags = new ArrayList();
        MetricsSourceAdapter sourceAdapter = new MetricsSourceAdapter("test", "test", "test JMX cache update race condition", sourceBuilder.build(), injectedTags, null, null, 250L, false);
        ScheduledExecutorService updaterExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().build());
        ScheduledExecutorService readerExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().build());
        AtomicBoolean hasError = new AtomicBoolean(false);
        SourceUpdater srcUpdater = new SourceUpdater(sourceAdapter, hasError);
        ScheduledFuture<?> updaterFuture = updaterExecutor.scheduleAtFixedRate(srcUpdater, sourceAdapter.getJmxCacheTTL(), sourceAdapter.getJmxCacheTTL(), TimeUnit.MILLISECONDS);
        srcUpdater.setFuture(updaterFuture);
        SourceReader srcReader = new SourceReader(source, sourceAdapter, hasError);
        ScheduledFuture<?> readerFuture = readerExecutor.scheduleAtFixedRate(srcReader, 0L, 2L * sourceAdapter.getJmxCacheTTL(), TimeUnit.MILLISECONDS);
        srcReader.setFuture(readerFuture);
        Thread.sleep(10000L);
        Assert.assertFalse((String)"Hit error", (boolean)hasError.get());
        updaterExecutor.shutdownNow();
        readerExecutor.shutdownNow();
        updaterExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        readerExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
    }

    private static class SourceReader
    implements Runnable {
        private MetricsSourceAdapter sa = null;
        private TestMetricsSource src = null;
        private int cnt = 0;
        private ScheduledFuture<?> future = null;
        private AtomicBoolean hasError = null;
        private static final Logger LOG = Logger.getLogger(SourceReader.class);

        public SourceReader(TestMetricsSource source, MetricsSourceAdapter sourceAdapter, AtomicBoolean err) {
            this.src = source;
            this.sa = sourceAdapter;
            this.hasError = err;
        }

        public void setFuture(ScheduledFuture<?> f) {
            this.future = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MBeanInfo info = this.sa.getMBeanInfo();
                String key = this.src.getKey();
                for (MBeanAttributeInfo mBeanAttributeInfo : info.getAttributes()) {
                    if (!mBeanAttributeInfo.getName().equals(key)) continue;
                    LOG.info((Object)("found key/val=" + this.cnt + "/" + this.cnt));
                    ++this.cnt;
                    this.src.setKV("key" + this.cnt, this.cnt);
                    return;
                }
                LOG.error((Object)("key=" + key + " not found. Stopping now."));
                this.hasError.set(true);
            }
            catch (Exception e) {
                this.hasError.set(true);
                LOG.error((Object)e.getStackTrace());
            }
            finally {
                if (this.hasError.get()) {
                    this.future.cancel(false);
                }
            }
        }
    }

    private static class SourceUpdater
    implements Runnable {
        private MetricsSourceAdapter sa = null;
        private ScheduledFuture<?> future = null;
        private AtomicBoolean hasError = null;
        private static final Logger LOG = Logger.getLogger(SourceUpdater.class);

        public SourceUpdater(MetricsSourceAdapter sourceAdapter, AtomicBoolean err) {
            this.sa = sourceAdapter;
            this.hasError = err;
        }

        public void setFuture(ScheduledFuture<?> f) {
            this.future = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MetricsCollectorImpl builder = new MetricsCollectorImpl();
            try {
                this.sa.getMetrics(builder, true);
                LOG.info((Object)"reset lastRecs");
            }
            catch (Exception e) {
                this.hasError.set(true);
                LOG.error((Object)e.getStackTrace());
            }
            finally {
                if (this.hasError.get()) {
                    LOG.error((Object)"Hit error, stopping now");
                    this.future.cancel(false);
                }
            }
        }
    }

    private static class TestMetricsSource
    implements MetricsSource {
        private String key = "key0";
        private int val = 0;

        private TestMetricsSource() {
        }

        synchronized String getKey() {
            return this.key;
        }

        synchronized void setKV(String newKey, int newVal) {
            this.key = newKey;
            this.val = newVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getMetrics(MetricsCollector collector, boolean all) {
            MetricsRecordBuilder rb = collector.addRecord("TestMetricsSource").setContext("test");
            TestMetricsSource testMetricsSource = this;
            synchronized (testMetricsSource) {
                rb.addGauge(Interns.info((String)this.key, (String)"TestMetricsSource key"), this.val);
            }
        }
    }

    @Metrics(context="test")
    private static class TestSource {
        @Metric(value={"C1 desc"})
        MutableCounterLong c1;
        final MetricsRegistry registry;

        TestSource(String recName) {
            this.registry = new MetricsRegistry(recName);
        }

        public void incrementCnt() {
            this.c1.incr();
        }
    }

    private static class PurgableSource
    implements MetricsSource {
        int nextKey = 0;
        String lastKeyName = null;

        private PurgableSource() {
        }

        public void getMetrics(MetricsCollector collector, boolean all) {
            MetricsRecordBuilder rb = collector.addRecord("purgablesource").setContext("test");
            this.lastKeyName = "key" + this.nextKey++;
            rb.addGauge(Interns.info((String)this.lastKeyName, (String)"desc"), 1);
        }
    }
}

