/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanValidationException;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.optimizer.AllExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

public class ColumnAliasConversionVisitor
extends AllExpressionVisitor {
    public ColumnAliasConversionVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    @Override
    protected LogicalExpressionVisitor getVisitor(LogicalExpressionPlan exprPlan) throws FrontendException {
        return new LogicalExpressionVisitor(exprPlan, new DependencyOrderWalker(exprPlan)){

            @Override
            public void visit(ProjectExpression expr) throws FrontendException {
                expr.setColumnNumberFromAlias();
            }

            @Override
            public void visit(DereferenceExpression expr) throws FrontendException {
                List<Object> rawCols = expr.getRawColumns();
                if (rawCols.isEmpty()) {
                    return;
                }
                ArrayList<Integer> cols = new ArrayList<Integer>(rawCols.size());
                LogicalExpressionPlan plan = (LogicalExpressionPlan)expr.getPlan();
                LogicalExpression pred = (LogicalExpression)plan.getSuccessors(expr).get(0);
                LogicalSchema schema = null;
                if (pred.getFieldSchema().type == 120) {
                    if (pred.getFieldSchema().schema != null && (schema = pred.getFieldSchema().schema.getField((int)0).schema) != null && schema.size() == 1 && schema.getField((int)0).type == 110) {
                        schema = schema.getField((int)0).schema;
                    }
                } else {
                    schema = pred.getFieldSchema().schema;
                }
                int col = -1;
                for (Object rc : rawCols) {
                    if (rc instanceof Integer) {
                        col = (Integer)rc;
                        if (schema != null && schema.size() != 0 && col >= schema.size()) {
                            throw new PlanValidationException(expr, "Out of bound access. Trying to access non-existent column: " + col + ". Schema " + schema.toString(false) + " has " + schema.size() + " column(s).", 1000);
                        }
                        cols.add((Integer)rc);
                        continue;
                    }
                    int n = col = schema == null ? -1 : schema.getFieldPosition((String)rc);
                    if (col == -1) {
                        throw new PlanValidationException(expr, "Invalid field reference. Referenced field [" + rc + "] does not exist in schema: " + (schema != null ? schema.toString(false) : "") + ".", 1000);
                    }
                    cols.add(col);
                }
                expr.setBagColumns(cols);
            }
        };
    }
}

