/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.constraints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.constraints.Violations;
import org.apache.accumulo.core.data.ComparableBytes;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.constraints.SystemConstraint;
import org.apache.accumulo.server.constraints.UnsatisfiableConstraint;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.log4j.Logger;

public class ConstraintChecker {
    private ArrayList<Constraint> constrains;
    private static final Logger log = Logger.getLogger(ConstraintChecker.class);
    private ClassLoader loader;
    private TableConfiguration conf;
    private AtomicLong lastCheck = new AtomicLong(0L);

    public ConstraintChecker(TableConfiguration conf) {
        this.constrains = new ArrayList();
        this.conf = conf;
        try {
            String context = conf.get(Property.TABLE_CLASSPATH);
            this.loader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            Iterator<Map.Entry<String, String>> i$ = conf.iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> entry = i$.next();
                if (!entry.getKey().startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey())) continue;
                String className = entry.getValue();
                Class<Constraint> clazz = this.loader.loadClass(className).asSubclass(Constraint.class);
                log.debug((Object)("Loaded constraint " + clazz.getName() + " for " + conf.getTableId()));
                this.constrains.add(clazz.newInstance());
            }
            this.lastCheck.set(System.currentTimeMillis());
        }
        catch (Throwable e) {
            this.constrains.clear();
            this.loader = null;
            this.constrains.add(new UnsatisfiableConstraint(-1, "Failed to load constraints, not accepting mutations."));
            log.error((Object)("Failed to load constraints " + conf.getTableId() + " " + e.toString()), e);
        }
    }

    public boolean classLoaderChanged() {
        if (this.constrains.size() == 0) {
            return false;
        }
        try {
            String context = this.conf.get(Property.TABLE_CLASSPATH);
            ClassLoader currentLoader = context != null && !context.equals("") ? AccumuloVFSClassLoader.getContextManager().getClassLoader(context) : AccumuloVFSClassLoader.getClassLoader();
            return currentLoader != this.loader;
        }
        catch (Exception e) {
            log.debug((Object)("Failed to check " + e.getMessage()));
            return true;
        }
    }

    public Violations check(Constraint.Environment env, Mutation m) {
        Violations violations = null;
        if (!env.getExtent().contains((BinaryComparable)new ComparableBytes(m.getRow()))) {
            violations = new Violations();
            ConstraintViolationSummary cvs = new ConstraintViolationSummary(SystemConstraint.class.getName(), -1, "Mutation outside of tablet extent", 1L);
            violations.add(cvs);
            return violations;
        }
        for (Constraint constraint : this.constrains) {
            String msg;
            short vcode;
            ConstraintViolationSummary cvs;
            List violationCodes = null;
            Throwable throwable = null;
            try {
                violationCodes = constraint.check(env, m);
            }
            catch (Throwable t) {
                throwable = t;
                log.warn((Object)("CONSTRAINT FAILED : " + throwable.getMessage()), t);
            }
            if (violationCodes != null) {
                for (Short vcode2 : violationCodes) {
                    cvs = new ConstraintViolationSummary(constraint.getClass().getName(), vcode2.shortValue(), constraint.getViolationDescription(vcode2.shortValue()), 1L);
                    if (violations == null) {
                        violations = new Violations();
                    }
                    violations.add(cvs);
                }
                continue;
            }
            if (throwable == null) continue;
            if (throwable instanceof NullPointerException) {
                vcode = -1;
                msg = "threw NullPointerException";
            } else if (throwable instanceof ArrayIndexOutOfBoundsException) {
                vcode = -2;
                msg = "threw ArrayIndexOutOfBoundsException";
            } else if (throwable instanceof NumberFormatException) {
                vcode = -3;
                msg = "threw NumberFormatException";
            } else if (throwable instanceof IOException) {
                vcode = -4;
                msg = "threw IOException (or subclass of)";
            } else {
                vcode = -100;
                msg = "threw some Exception";
            }
            cvs = new ConstraintViolationSummary(constraint.getClass().getName(), vcode, "CONSTRAINT FAILED : " + msg, 1L);
            if (violations == null) {
                violations = new Violations();
            }
            violations.add(cvs);
        }
        return violations;
    }
}

