/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.IdLock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestIdLock {
    private static final Log LOG = LogFactory.getLog(TestIdLock.class);
    private static final int NUM_IDS = 16;
    private static final int NUM_THREADS = 128;
    private static final int NUM_SECONDS = 15;
    private IdLock idLock = new IdLock();
    private Map<Long, String> idOwner = new ConcurrentHashMap<Long, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleClients() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(128);
        try {
            int i;
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(exec);
            for (i = 0; i < 128; ++i) {
                ecs.submit(new IdLockTestThread("client_" + i));
            }
            for (i = 0; i < 128; ++i) {
                Future result = ecs.take();
                Assert.assertTrue((boolean)((Boolean)result.get()));
            }
            this.idLock.assertMapEmpty();
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
    }

    private class IdLockTestThread
    implements Callable<Boolean> {
        private String clientId;

        public IdLockTestThread(String clientId) {
            this.clientId = clientId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            Thread.currentThread().setName(this.clientId);
            Random rand = new Random();
            long endTime = System.currentTimeMillis() + 15000L;
            while (System.currentTimeMillis() < endTime) {
                long id = rand.nextInt(16);
                IdLock.Entry lockEntry = TestIdLock.this.idLock.getLockEntry(id);
                try {
                    int sleepMs = 1 + rand.nextInt(4);
                    String owner = (String)TestIdLock.this.idOwner.get(id);
                    if (owner != null) {
                        LOG.error((Object)("Id " + id + " already taken by " + owner + ", " + this.clientId + " failed"));
                        Boolean bl = false;
                        return bl;
                    }
                    TestIdLock.this.idOwner.put(id, this.clientId);
                    Thread.sleep(sleepMs);
                    TestIdLock.this.idOwner.remove(id);
                }
                finally {
                    TestIdLock.this.idLock.releaseLockEntry(lockEntry);
                }
            }
            return true;
        }
    }
}

