/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.AuthMessage;
import org.apache.spark.network.sasl.SaslRpcHandler;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.AbstractAuthRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.base.Throwables;

class AuthRpcHandler
extends AbstractAuthRpcHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthRpcHandler.class);
    private final TransportConf conf;
    private final Channel channel;
    private final SecretKeyHolder secretKeyHolder;
    @VisibleForTesting
    SaslRpcHandler saslHandler;

    AuthRpcHandler(TransportConf conf, Channel channel, RpcHandler delegate, SecretKeyHolder secretKeyHolder) {
        super(delegate);
        this.conf = conf;
        this.channel = channel;
        this.secretKeyHolder = secretKeyHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doAuthChallenge(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
        AuthMessage challenge;
        if (this.saslHandler != null) {
            return this.saslHandler.doAuthChallenge(client, message, callback);
        }
        int position = message.position();
        int limit = message.limit();
        try {
            challenge = AuthMessage.decodeMessage(message);
            LOG.debug("Received new auth challenge for client {}.", (Object)this.channel.remoteAddress());
        }
        catch (RuntimeException e) {
            if (this.conf.saslFallback()) {
                LOG.warn("Failed to parse new auth challenge, reverting to SASL for client {}.", (Object)this.channel.remoteAddress());
                this.saslHandler = new SaslRpcHandler(this.conf, this.channel, null, this.secretKeyHolder);
                message.position(position);
                message.limit(limit);
                return this.saslHandler.doAuthChallenge(client, message, callback);
            }
            LOG.debug("Unexpected challenge message from client {}, closing channel.", (Object)this.channel.remoteAddress());
            callback.onFailure(new IllegalArgumentException("Unknown challenge message."));
            this.channel.close();
            return false;
        }
        AuthEngine engine = null;
        try {
            String secret = this.secretKeyHolder.getSecretKey(challenge.appId);
            Preconditions.checkState(secret != null, "Trying to authenticate non-registered app %s.", challenge.appId);
            LOG.debug("Authenticating challenge for app {}.", (Object)challenge.appId);
            engine = new AuthEngine(challenge.appId, secret, this.conf);
            AuthMessage response = engine.response(challenge);
            ByteBuf responseData = Unpooled.buffer((int)response.encodedLength());
            response.encode(responseData);
            callback.onSuccess(responseData.nioBuffer());
            engine.sessionCipher().addToChannel(this.channel);
            client.setClientId(challenge.appId);
        }
        catch (Exception e) {
            LOG.debug("Authentication failed for client {}, closing channel.", (Object)this.channel.remoteAddress());
            callback.onFailure(new IllegalArgumentException("Authentication failed."));
            this.channel.close();
            boolean bl = false;
            return bl;
        }
        finally {
            if (engine != null) {
                try {
                    engine.close();
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        }
        LOG.debug("Authorization successful for client {}.", (Object)this.channel.remoteAddress());
        return true;
    }

    @Override
    public RpcHandler.MergedBlockMetaReqHandler getMergedBlockMetaReqHandler() {
        return this.saslHandler.getMergedBlockMetaReqHandler();
    }
}

