/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.orc.CompressionCodec;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.PositionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(InStream.class);
    public static final int PROTOBUF_MESSAGE_MAX_LIMIT = 0x40000000;
    protected final String name;
    protected long length;

    public InStream(String name, long length) {
        this.name = name;
        this.length = length;
    }

    public String getStreamName() {
        return this.name;
    }

    public long getStreamLength() {
        return this.length;
    }

    @Override
    public abstract void close();

    private static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        if (isDirect) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    public abstract void seek(PositionProvider var1) throws IOException;

    @Deprecated
    public static InStream create(String streamName, ByteBuffer[] buffers, long[] offsets, long length, CompressionCodec codec, int bufferSize) throws IOException {
        ArrayList<DiskRange> input = new ArrayList<DiskRange>(buffers.length);
        for (int i = 0; i < buffers.length; ++i) {
            input.add((DiskRange)new BufferChunk(buffers[i], offsets[i]));
        }
        return InStream.create(streamName, input, length, codec, bufferSize);
    }

    public static InStream create(String name, List<DiskRange> input, long length, CompressionCodec codec, int bufferSize) throws IOException {
        if (codec == null) {
            return new UncompressedStream(name, input, length);
        }
        return new CompressedStream(name, input, length, codec, bufferSize);
    }

    public static CodedInputStream createCodedInputStream(String name, List<DiskRange> input, long length, CompressionCodec codec, int bufferSize) throws IOException {
        InStream inStream = InStream.create(name, input, length, codec, bufferSize);
        CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)inStream);
        codedInputStream.setSizeLimit(0x40000000);
        return codedInputStream;
    }

    private static class CompressedStream
    extends InStream {
        private final List<DiskRange> bytes;
        private final int bufferSize;
        private ByteBuffer uncompressed;
        private final CompressionCodec codec;
        private ByteBuffer compressed;
        private long currentOffset;
        private int currentRange;
        private boolean isUncompressedOriginal;

        public CompressedStream(String name, List<DiskRange> input, long length, CompressionCodec codec, int bufferSize) {
            super(name, length);
            this.bytes = input;
            this.codec = codec;
            this.bufferSize = bufferSize;
            this.currentOffset = 0L;
            this.currentRange = 0;
        }

        private void allocateForUncompressed(int size, boolean isDirect) {
            this.uncompressed = InStream.allocateBuffer(size, isDirect);
        }

        private void readHeader() throws IOException {
            if (this.compressed == null || this.compressed.remaining() <= 0) {
                this.seek(this.currentOffset);
            }
            if (this.compressed.remaining() > 3) {
                int b0 = this.compressed.get() & 0xFF;
                int b1 = this.compressed.get() & 0xFF;
                int b2 = this.compressed.get() & 0xFF;
                boolean isOriginal = (b0 & 1) == 1;
                int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
                if (chunkLength > this.bufferSize) {
                    throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
                }
                this.currentOffset += 3L;
                ByteBuffer slice = this.slice(chunkLength);
                if (isOriginal) {
                    this.uncompressed = slice;
                    this.isUncompressedOriginal = true;
                } else {
                    if (this.isUncompressedOriginal) {
                        this.allocateForUncompressed(this.bufferSize, slice.isDirect());
                        this.isUncompressedOriginal = false;
                    } else if (this.uncompressed == null) {
                        this.allocateForUncompressed(this.bufferSize, slice.isDirect());
                    } else {
                        this.uncompressed.clear();
                    }
                    this.codec.decompress(slice, this.uncompressed);
                }
            } else {
                throw new IllegalStateException("Can't read header at " + this);
            }
        }

        @Override
        public int read() throws IOException {
            if (!this.ensureUncompressed()) {
                return -1;
            }
            return 0xFF & this.uncompressed.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) throws IOException {
            if (!this.ensureUncompressed()) {
                return -1;
            }
            int actualLength = Math.min(length, this.uncompressed.remaining());
            this.uncompressed.get(data, offset, actualLength);
            return actualLength;
        }

        private boolean ensureUncompressed() throws IOException {
            while (this.uncompressed == null || this.uncompressed.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return false;
                }
                this.readHeader();
            }
            return true;
        }

        @Override
        public int available() throws IOException {
            if (!this.ensureUncompressed()) {
                return 0;
            }
            return this.uncompressed.remaining();
        }

        @Override
        public void close() {
            this.uncompressed = null;
            this.compressed = null;
            this.currentRange = this.bytes.size();
            this.currentOffset = this.length;
            this.bytes.clear();
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
            long uncompressedBytes = index.getNext();
            if (uncompressedBytes != 0L) {
                this.readHeader();
                this.uncompressed.position(this.uncompressed.position() + (int)uncompressedBytes);
            } else if (this.uncompressed != null) {
                this.uncompressed.position(this.uncompressed.limit());
            }
        }

        private ByteBuffer slice(int chunkLength) throws IOException {
            int len = chunkLength;
            long oldOffset = this.currentOffset;
            if (this.compressed.remaining() >= len) {
                ByteBuffer slice = this.compressed.slice();
                slice.limit(len);
                this.currentOffset += (long)len;
                this.compressed.position(this.compressed.position() + len);
                return slice;
            }
            if (this.currentRange >= this.bytes.size() - 1) {
                throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Crossing into next BufferChunk because compressed only has %d bytes (needs %d)", this.compressed.remaining(), len));
            }
            ByteBuffer copy = InStream.allocateBuffer(chunkLength, this.compressed.isDirect());
            this.currentOffset += (long)this.compressed.remaining();
            len -= this.compressed.remaining();
            copy.put(this.compressed);
            ListIterator<DiskRange> iter = this.bytes.listIterator(this.currentRange);
            while (len > 0 && iter.hasNext()) {
                ++this.currentRange;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Read slow-path, >1 cross block reads with %s", this.toString()));
                }
                DiskRange range = iter.next();
                this.compressed = range.getData().duplicate();
                if (this.compressed.remaining() >= len) {
                    ByteBuffer slice = this.compressed.slice();
                    slice.limit(len);
                    copy.put(slice);
                    this.currentOffset += (long)len;
                    this.compressed.position(this.compressed.position() + len);
                    return copy;
                }
                this.currentOffset += (long)this.compressed.remaining();
                len -= this.compressed.remaining();
                copy.put(this.compressed);
            }
            this.seek(oldOffset);
            throw new IOException("EOF in " + this + " while trying to read " + chunkLength + " bytes");
        }

        private void seek(long desired) throws IOException {
            if (desired == 0L && this.bytes.isEmpty()) {
                return;
            }
            int i = 0;
            for (DiskRange range : this.bytes) {
                if (range.getOffset() <= desired && desired < range.getEnd()) {
                    this.currentRange = i;
                    this.compressed = range.getData().duplicate();
                    int pos = this.compressed.position();
                    this.compressed.position(pos += (int)(desired - range.getOffset()));
                    this.currentOffset = desired;
                    return;
                }
                ++i;
            }
            int segments = this.bytes.size();
            if (segments != 0 && desired == this.bytes.get(segments - 1).getEnd()) {
                DiskRange range;
                range = this.bytes.get(segments - 1);
                this.currentRange = segments - 1;
                this.compressed = range.getData().duplicate();
                this.compressed.position(this.compressed.limit());
                this.currentOffset = desired;
                return;
            }
            throw new IOException("Seek outside of data in " + this + " to " + desired);
        }

        private String rangeString() {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (DiskRange range : this.bytes) {
                if (i != 0) {
                    builder.append("; ");
                }
                builder.append(" range " + i + " = " + range.getOffset() + " to " + (range.getEnd() - range.getOffset()));
                ++i;
            }
            return builder.toString();
        }

        public String toString() {
            return "compressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + (this.compressed == null ? 0 : this.compressed.position()) + " limit: " + (this.compressed == null ? 0 : this.compressed.limit()) + this.rangeString() + (this.uncompressed == null ? "" : " uncompressed: " + this.uncompressed.position() + " to " + this.uncompressed.limit());
        }
    }

    public static class UncompressedStream
    extends InStream {
        private List<DiskRange> bytes;
        private long length;
        protected long currentOffset;
        private ByteBuffer range;
        private int currentRange;

        public UncompressedStream(String name, List<DiskRange> input, long length) {
            super(name, length);
            this.reset(input, length);
        }

        protected void reset(List<DiskRange> input, long length) {
            this.bytes = input;
            this.length = length;
            this.currentRange = 0;
            this.currentOffset = 0L;
            this.range = null;
        }

        @Override
        public int read() {
            if (this.range == null || this.range.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            ++this.currentOffset;
            return 0xFF & this.range.get();
        }

        @Override
        public int read(byte[] data, int offset, int length) {
            if (this.range == null || this.range.remaining() == 0) {
                if (this.currentOffset == this.length) {
                    return -1;
                }
                this.seek(this.currentOffset);
            }
            int actualLength = Math.min(length, this.range.remaining());
            this.range.get(data, offset, actualLength);
            this.currentOffset += (long)actualLength;
            return actualLength;
        }

        @Override
        public int available() {
            if (this.range != null && this.range.remaining() > 0) {
                return this.range.remaining();
            }
            return (int)(this.length - this.currentOffset);
        }

        @Override
        public void close() {
            this.currentRange = this.bytes.size();
            this.currentOffset = this.length;
            this.bytes.clear();
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.seek(index.getNext());
        }

        public void seek(long desired) {
            if (desired == 0L && this.bytes.isEmpty()) {
                return;
            }
            int i = 0;
            for (DiskRange curRange : this.bytes) {
                if (curRange.getOffset() <= desired && desired - curRange.getOffset() < (long)curRange.getLength()) {
                    this.currentOffset = desired;
                    this.currentRange = i;
                    this.range = curRange.getData().duplicate();
                    int pos = this.range.position();
                    this.range.position(pos += (int)(desired - curRange.getOffset()));
                    return;
                }
                ++i;
            }
            int segments = this.bytes.size();
            if (segments != 0 && desired == this.bytes.get(segments - 1).getEnd()) {
                DiskRange curRange;
                this.currentOffset = desired;
                this.currentRange = segments - 1;
                curRange = this.bytes.get(this.currentRange);
                this.range = curRange.getData().duplicate();
                int pos = this.range.position();
                this.range.position(pos += (int)(desired - curRange.getOffset()));
                return;
            }
            throw new IllegalArgumentException("Seek in " + this.name + " to " + desired + " is outside of the data");
        }

        public String toString() {
            return "uncompressed stream " + this.name + " position: " + this.currentOffset + " length: " + this.length + " range: " + this.currentRange + " offset: " + (this.range == null ? 0 : this.range.position()) + " limit: " + (this.range == null ? 0 : this.range.limit());
        }
    }
}

