/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.junit.Assert;
import org.junit.Test;

public class TestFileStatusSerialization {
    private static final URI BASEURI = new Path("hdfs://foobar").toUri();
    private static final Path BASEPATH = new Path("/dingos");
    private static final String FILE = "zot";
    private static final Path FULLPATH = new Path("hdfs://foobar/dingos/zot");

    private static void checkFields(FileStatus expected, FileStatus actual) {
        Assert.assertEquals((Object)expected.getPath(), (Object)actual.getPath());
        Assert.assertEquals((Object)expected.isDirectory(), (Object)actual.isDirectory());
        Assert.assertEquals((long)expected.getLen(), (long)actual.getLen());
        Assert.assertEquals((Object)expected.getPermission(), (Object)actual.getPermission());
        Assert.assertEquals((Object)expected.getOwner(), (Object)actual.getOwner());
        Assert.assertEquals((Object)expected.getGroup(), (Object)actual.getGroup());
        Assert.assertEquals((long)expected.getModificationTime(), (long)actual.getModificationTime());
        Assert.assertEquals((long)expected.getAccessTime(), (long)actual.getAccessTime());
        Assert.assertEquals((long)expected.getReplication(), (long)actual.getReplication());
        Assert.assertEquals((long)expected.getBlockSize(), (long)actual.getBlockSize());
    }

    private static HdfsProtos.HdfsFileStatusProto.Builder baseStatus() {
        FsPermission perm = FsPermission.getFileDefault();
        HdfsProtos.HdfsFileStatusProto.Builder hspb = HdfsProtos.HdfsFileStatusProto.newBuilder().setFileType(HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE).setPath(ByteString.copyFromUtf8((String)FILE)).setLength(4344L).setPermission(PBHelperClient.convert((FsPermission)perm)).setOwner("hadoop").setGroup("unqbbc").setModificationTime(12345678L).setAccessTime(87654321L).setBlockReplication(10).setBlocksize(0x200000000L).setFlags(0);
        return hspb;
    }

    @Test
    public void testFsPermissionCompatibility() throws Exception {
        int flagmask = 8;
        for (int i = 0; i < 8; ++i) {
            FsPermission perm = FsPermission.createImmutable((short)11);
            HdfsProtos.HdfsFileStatusProto.Builder hspb = TestFileStatusSerialization.baseStatus().setPermission(PBHelperClient.convert((FsPermission)perm)).setFlags(i);
            HdfsFileStatus stat = PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)hspb.build());
            stat.makeQualified(BASEURI, BASEPATH);
            Assert.assertEquals((Object)FULLPATH, (Object)stat.getPath());
            FsPermission sp = stat.getPermission();
            Assert.assertEquals((Object)sp.getAclBit(), (Object)stat.hasAcl());
            Assert.assertEquals((Object)sp.getEncryptedBit(), (Object)stat.isEncrypted());
            Assert.assertEquals((Object)sp.getErasureCodedBit(), (Object)stat.isErasureCoded());
            DataOutputBuffer dob = new DataOutputBuffer();
            stat.write((DataOutput)dob);
            DataInputBuffer dib = new DataInputBuffer();
            dib.reset(dob.getData(), 0, dob.getLength());
            FileStatus fstat = new FileStatus();
            fstat.readFields((DataInput)dib);
            TestFileStatusSerialization.checkFields((FileStatus)stat, fstat);
            Assert.assertEquals((Object)sp.getAclBit(), (Object)fstat.hasAcl());
            Assert.assertEquals((Object)sp.getEncryptedBit(), (Object)fstat.isEncrypted());
            Assert.assertEquals((Object)sp.getErasureCodedBit(), (Object)fstat.isErasureCoded());
        }
    }

    @Test
    public void testJavaSerialization() throws Exception {
        HdfsProtos.HdfsFileStatusProto hsp = TestFileStatusSerialization.baseStatus().build();
        HdfsFileStatus hs = PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)hsp);
        hs.makeQualified(BASEURI, BASEPATH);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(hs);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (ObjectInputStream ois = new ObjectInputStream(bais);){
            FileStatus deser = (FileStatus)ois.readObject();
            Assert.assertEquals((Object)hs, (Object)deser);
            TestFileStatusSerialization.checkFields((FileStatus)hs, deser);
        }
    }

    @Test
    public void testCrossSerializationProto() throws Exception {
        for (HdfsProtos.HdfsFileStatusProto.FileType t : HdfsProtos.HdfsFileStatusProto.FileType.values()) {
            HdfsProtos.HdfsFileStatusProto.Builder hspb = TestFileStatusSerialization.baseStatus().setFileType(t);
            if (HdfsProtos.HdfsFileStatusProto.FileType.IS_SYMLINK.equals((Object)t)) {
                hspb.setSymlink(ByteString.copyFromUtf8((String)"hdfs://yaks/dingos"));
            }
            if (HdfsProtos.HdfsFileStatusProto.FileType.IS_FILE.equals((Object)t)) {
                hspb.setFileId(4544L);
            }
            HdfsProtos.HdfsFileStatusProto hsp = hspb.build();
            byte[] src = hsp.toByteArray();
            FSProtos.FileStatusProto fsp = FSProtos.FileStatusProto.parseFrom((byte[])src);
            Assert.assertEquals((Object)hsp.getPath().toStringUtf8(), (Object)fsp.getPath());
            Assert.assertEquals((long)hsp.getLength(), (long)fsp.getLength());
            Assert.assertEquals((long)hsp.getPermission().getPerm(), (long)fsp.getPermission().getPerm());
            Assert.assertEquals((Object)hsp.getOwner(), (Object)fsp.getOwner());
            Assert.assertEquals((Object)hsp.getGroup(), (Object)fsp.getGroup());
            Assert.assertEquals((long)hsp.getModificationTime(), (long)fsp.getModificationTime());
            Assert.assertEquals((long)hsp.getAccessTime(), (long)fsp.getAccessTime());
            Assert.assertEquals((Object)hsp.getSymlink().toStringUtf8(), (Object)fsp.getSymlink());
            Assert.assertEquals((long)hsp.getBlockReplication(), (long)fsp.getBlockReplication());
            Assert.assertEquals((long)hsp.getBlocksize(), (long)fsp.getBlockSize());
            Assert.assertEquals((long)hsp.getFileType().ordinal(), (long)fsp.getFileType().ordinal());
            byte[] dst = fsp.toByteArray();
            HdfsProtos.HdfsFileStatusProto hsp2 = HdfsProtos.HdfsFileStatusProto.parseFrom((byte[])dst);
            Assert.assertEquals((Object)hsp, (Object)hsp2);
            FileStatus hstat = (FileStatus)PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)hsp);
            FileStatus hstat2 = (FileStatus)PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)hsp2);
            TestFileStatusSerialization.checkFields(hstat, hstat2);
        }
    }
}

