/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.rules.ColumnPruneHelper;
import org.apache.pig.newplan.logical.rules.ColumnPruneVisitor;
import org.apache.pig.newplan.logical.rules.MapKeysPruneHelper;
import org.apache.pig.newplan.logical.rules.WholePlanRule;
import org.apache.pig.newplan.optimizer.Transformer;

public class ColumnMapKeyPrune
extends WholePlanRule {
    private boolean hasRun = false;

    public ColumnMapKeyPrune(String n) {
        super(n, false);
    }

    @Override
    public Transformer getNewTransformer() {
        return new ColumnMapKeyPruneTransformer();
    }

    public class ColumnMapKeyPruneTransformer
    extends Transformer {
        private MapKeysPruneHelper mapKeyHelper;
        private ColumnPruneHelper columnHelper;
        private boolean columnPrune;
        private boolean mapKeyPrune;
        private Map<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>> requiredItems = new HashMap<LOLoad, Pair<Map<Integer, Set<String>>, Set<Integer>>>();

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            if (ColumnMapKeyPrune.this.hasRun) {
                return false;
            }
            ColumnMapKeyPrune.this.hasRun = true;
            this.mapKeyHelper = new MapKeysPruneHelper(matched);
            this.columnHelper = new ColumnPruneHelper(matched);
            this.mapKeyPrune = this.mapKeyHelper.check();
            this.columnPrune = this.columnHelper.check();
            return this.mapKeyPrune || this.columnPrune;
        }

        @Override
        public OperatorPlan reportChanges() {
            return ColumnMapKeyPrune.this.currentPlan;
        }

        private void merge() throws FrontendException {
            for (Operator source : ColumnMapKeyPrune.this.currentPlan.getSources()) {
                Map mapKeys = (Map)source.getAnnotation("MapPruner:RequiredKeys");
                HashSet<Integer> requiredColumns = null;
                if (source.getAnnotation("ColumnPrune:RequiredColumns") != null) {
                    requiredColumns = new HashSet<Integer>((Set)source.getAnnotation("ColumnPrune:RequiredColumns"));
                }
                if (requiredColumns == null && mapKeys == null) continue;
                if (requiredColumns != null && mapKeys != null) {
                    HashSet<Integer> duplicatedCols = new HashSet<Integer>();
                    for (Integer col : requiredColumns) {
                        if (!mapKeys.containsKey(col)) continue;
                        duplicatedCols.add(col);
                    }
                    requiredColumns.removeAll(duplicatedCols);
                } else if (mapKeys != null && requiredColumns == null) {
                    requiredColumns = new HashSet();
                    for (int i = 0; i < ((LogicalRelationalOperator)source).getSchema().size(); ++i) {
                        if (mapKeys.containsKey(i)) continue;
                        requiredColumns.add(i);
                    }
                }
                this.requiredItems.put((LOLoad)source, new Pair(mapKeys, requiredColumns));
            }
        }

        @Override
        public void transform(OperatorPlan matched) throws FrontendException {
            this.merge();
            ColumnPruneVisitor columnPruneVisitor = new ColumnPruneVisitor(ColumnMapKeyPrune.this.currentPlan, this.requiredItems, this.columnPrune);
            columnPruneVisitor.visit();
        }
    }
}

