/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.impl.TabletIdImpl;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.hadoop.io.Text;

public class ActiveCompactionImpl
extends ActiveCompaction {
    private org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac;
    private Instance instance;

    ActiveCompactionImpl(Instance instance, org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac) {
        this.tac = tac;
        this.instance = instance;
    }

    @Override
    public String getTable() throws TableNotFoundException {
        return Tables.getTableName(this.instance, new KeyExtent(this.tac.getExtent()).getTableId());
    }

    @Override
    @Deprecated
    public org.apache.accumulo.core.data.KeyExtent getExtent() {
        KeyExtent ke = new KeyExtent(this.tac.getExtent());
        org.apache.accumulo.core.data.KeyExtent oke = new org.apache.accumulo.core.data.KeyExtent(new Text(ke.getTableId()), ke.getEndRow(), ke.getPrevEndRow());
        return oke;
    }

    @Override
    public TabletId getTablet() {
        return new TabletIdImpl(new KeyExtent(this.tac.getExtent()));
    }

    @Override
    public long getAge() {
        return this.tac.getAge();
    }

    @Override
    public List<String> getInputFiles() {
        return this.tac.getInputFiles();
    }

    @Override
    public String getOutputFile() {
        return this.tac.getOutputFile();
    }

    @Override
    public ActiveCompaction.CompactionType getType() {
        return ActiveCompaction.CompactionType.valueOf(this.tac.getType().name());
    }

    @Override
    public ActiveCompaction.CompactionReason getReason() {
        return ActiveCompaction.CompactionReason.valueOf(this.tac.getReason().name());
    }

    @Override
    public String getLocalityGroup() {
        return this.tac.getLocalityGroup();
    }

    @Override
    public long getEntriesRead() {
        return this.tac.getEntriesRead();
    }

    @Override
    public long getEntriesWritten() {
        return this.tac.getEntriesWritten();
    }

    @Override
    public List<IteratorSetting> getIterators() {
        ArrayList<IteratorSetting> ret = new ArrayList<IteratorSetting>();
        for (IterInfo ii : this.tac.getSsiList()) {
            IteratorSetting settings = new IteratorSetting(ii.getPriority(), ii.getIterName(), ii.getClassName());
            Map<String, String> options = this.tac.getSsio().get(ii.getIterName());
            settings.addOptions(options);
            ret.add(settings);
        }
        return ret;
    }
}

