/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyShortener {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] B00 = new byte[]{0};
    private static final byte[] BFF = new byte[]{-1};
    private static final Logger log = LoggerFactory.getLogger(KeyShortener.class);

    private KeyShortener() {
    }

    private static int findNonFF(ByteSequence bs, int start) {
        for (int i = start; i < bs.length(); ++i) {
            if (bs.byteAt(i) == -1) continue;
            return i;
        }
        return bs.length();
    }

    public static ByteSequence shorten(ByteSequence prev, ByteSequence current) {
        int minLen = Math.min(prev.length(), current.length());
        for (int i = 0; i < minLen; ++i) {
            int pb = 0xFF & prev.byteAt(i);
            int cb = 0xFF & current.byteAt(i);
            int diff = cb - pb;
            if (diff == 1) {
                int newLen = KeyShortener.findNonFF(prev, i + 1);
                byte[] successor = newLen < prev.length() ? Bytes.concat((byte[][])new byte[][]{prev.subSequence(0, newLen).toArray(), BFF}) : Bytes.concat((byte[][])new byte[][]{prev.subSequence(0, newLen).toArray(), B00});
                return new ArrayByteSequence(successor);
            }
            if (diff <= 1) continue;
            byte[] copy = new byte[i + 1];
            System.arraycopy(prev.subSequence(0, i + 1).toArray(), 0, copy, 0, i + 1);
            copy[i] = (byte)((0xFF & copy[i]) + 1);
            return new ArrayByteSequence(copy);
        }
        ArrayByteSequence successor = new ArrayByteSequence(Bytes.concat((byte[][])new byte[][]{prev.toArray(), B00}));
        if (successor.equals(current)) {
            return null;
        }
        return successor;
    }

    @VisibleForTesting
    static Key sanityCheck(Key prev, Key current, Key shortened) {
        if (prev.compareTo(shortened) >= 0) {
            log.warn("Bug in key shortening code, please open an issue " + prev + " >= " + shortened);
            return prev;
        }
        if (current.compareTo(shortened) <= 0) {
            log.warn("Bug in key shortening code, please open an issue " + current + " <= " + shortened);
            return prev;
        }
        return shortened;
    }

    public static Key shorten(Key prev, Key current) {
        Preconditions.checkArgument((prev.compareTo(current) <= 0 ? 1 : 0) != 0, (Object)("Expected key less than or equal. " + prev + " > " + current));
        if (prev.getRowData().compareTo(current.getRowData()) < 0) {
            ByteSequence shortenedRow = KeyShortener.shorten(prev.getRowData(), current.getRowData());
            if (shortenedRow == null) {
                return prev;
            }
            return KeyShortener.sanityCheck(prev, current, new Key(shortenedRow.toArray(), EMPTY, EMPTY, EMPTY, 0L));
        }
        if (prev.getColumnFamilyData().compareTo(current.getColumnFamilyData()) < 0) {
            ByteSequence shortenedFam = KeyShortener.shorten(prev.getColumnFamilyData(), current.getColumnFamilyData());
            if (shortenedFam == null) {
                return prev;
            }
            return KeyShortener.sanityCheck(prev, current, new Key(prev.getRowData().toArray(), shortenedFam.toArray(), EMPTY, EMPTY, 0L));
        }
        if (prev.getColumnQualifierData().compareTo(current.getColumnQualifierData()) < 0) {
            ByteSequence shortenedQual = KeyShortener.shorten(prev.getColumnQualifierData(), current.getColumnQualifierData());
            if (shortenedQual == null) {
                return prev;
            }
            return KeyShortener.sanityCheck(prev, current, new Key(prev.getRowData().toArray(), prev.getColumnFamilyData().toArray(), shortenedQual.toArray(), EMPTY, 0L));
        }
        return prev;
    }
}

