/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractIterator<T>
implements Iterator<T> {
    private T next;
    private State currentState = State.NOT_STARTED;

    @Override
    public boolean hasNext() {
        switch (this.currentState) {
            case DONE: {
                return false;
            }
            case NOT_STARTED: {
                this.currentState = State.HAS_DATA;
                this.next = this.computeNext();
                break;
            }
            case HAS_DATA: {
                return true;
            }
            case EMPTY: {
                this.currentState = State.HAS_DATA;
                this.next = this.computeNext();
            }
        }
        return this.currentState != State.DONE;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            T r = this.next;
            this.currentState = State.EMPTY;
            return r;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from an abstract iterator");
    }

    protected abstract T computeNext();

    public T endOfData() {
        this.currentState = State.DONE;
        return null;
    }

    private static enum State {
        NOT_STARTED,
        DONE,
        HAS_DATA,
        EMPTY;

    }
}

