/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FairQueuePlacementUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultPlacementRule
extends FSPlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPlacementRule.class);
    @VisibleForTesting
    public String defaultQueueName;

    @Override
    public void setConfig(Element conf) {
        this.createQueue = this.getCreateFlag(conf);
        if (conf != null) {
            this.defaultQueueName = conf.getAttribute("queue");
            if (!FairQueuePlacementUtils.isValidQueueName(this.defaultQueueName)) {
                LOG.error("Default rule configured with an illegal queue name: '{}'", (Object)this.defaultQueueName);
                this.defaultQueueName = null;
            }
        }
        this.defaultQueueName = this.defaultQueueName == null || this.defaultQueueName.isEmpty() ? FairQueuePlacementUtils.assureRoot("default") : FairQueuePlacementUtils.assureRoot(this.defaultQueueName);
        LOG.debug("Default rule instantiated with queue name: {}, and create flag: {}", (Object)this.defaultQueueName, (Object)this.createQueue);
    }

    @Override
    public void setConfig(Boolean create) {
        this.createQueue = create;
        this.defaultQueueName = FairQueuePlacementUtils.assureRoot("default");
        LOG.debug("Default rule instantiated with default queue name: {}, and create flag: {}", (Object)this.defaultQueueName, (Object)this.createQueue);
    }

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        super.initialize(scheduler);
        if (this.getParentRule() != null) {
            throw new IOException("Parent rule must not be configured for Default rule.");
        }
        return true;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) {
        if (this.createQueue || this.configuredQueue(this.defaultQueueName)) {
            return new ApplicationPlacementContext(this.defaultQueueName);
        }
        return null;
    }
}

