/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanQueue
extends AbstractManagedParentQueue {
    private static final Logger LOG = LoggerFactory.getLogger(PlanQueue.class);
    private int maxAppsForReservation;
    private int maxAppsPerUserForReservation;
    private int userLimit;
    private float userLimitFactor;
    protected CapacitySchedulerContext schedulerContext;
    private boolean showReservationsAsQueues;

    public PlanQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.schedulerContext = cs;
        CapacitySchedulerConfiguration conf = cs.getConfiguration();
        String queuePath = super.getQueuePath();
        int maxAppsForReservation = conf.getMaximumApplicationsPerQueue(queuePath);
        this.showReservationsAsQueues = conf.getShowReservationAsQueues(queuePath);
        if (maxAppsForReservation < 0) {
            maxAppsForReservation = (int)(10000.0f * super.getAbsoluteCapacity());
        }
        int userLimit = conf.getUserLimit(queuePath);
        float userLimitFactor = conf.getUserLimitFactor(queuePath);
        int maxAppsPerUserForReservation = (int)((float)maxAppsForReservation * ((float)userLimit / 100.0f) * userLimitFactor);
        this.updateQuotas(userLimit, userLimitFactor, maxAppsForReservation, maxAppsPerUserForReservation);
        StringBuffer queueInfo = new StringBuffer();
        queueInfo.append("Created Plan Queue: ").append(queueName).append("\nwith capacity: [").append(super.getCapacity()).append("]\nwith max capacity: [").append(super.getMaximumCapacity()).append("\nwith max reservation apps: [").append(maxAppsForReservation).append("]\nwith max reservation apps per user: [").append(maxAppsPerUserForReservation).append("]\nwith user limit: [").append(userLimit).append("]\nwith user limit factor: [").append(userLimitFactor).append("].");
        LOG.info(queueInfo.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        this.writeLock.lock();
        try {
            if (!(newlyParsedQueue instanceof PlanQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            PlanQueue newlyParsedParentQueue = (PlanQueue)newlyParsedQueue;
            if (newlyParsedParentQueue.getChildQueues().size() != 1) {
                throw new IOException("Reservable Queue should not have sub-queues in theconfiguration expect the default reservation queue");
            }
            this.setupQueueConfigs(clusterResource);
            this.updateQuotas(newlyParsedParentQueue.userLimit, newlyParsedParentQueue.userLimitFactor, newlyParsedParentQueue.maxAppsForReservation, newlyParsedParentQueue.maxAppsPerUserForReservation);
            for (CSQueue res : this.getChildQueues()) {
                res.reinitialize(res, clusterResource);
            }
            this.showReservationsAsQueues = newlyParsedParentQueue.showReservationsAsQueues;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateQuotas(int userLimit, float userLimitFactor, int maxAppsForReservation, int maxAppsPerUserForReservation) {
        this.userLimit = userLimit;
        this.userLimitFactor = userLimitFactor;
        this.maxAppsForReservation = maxAppsForReservation;
        this.maxAppsPerUserForReservation = maxAppsPerUserForReservation;
    }

    public int getMaxApplicationsForReservations() {
        return this.maxAppsForReservation;
    }

    public int getMaxApplicationsPerUserForReservation() {
        return this.maxAppsPerUserForReservation;
    }

    public int getUserLimitForReservation() {
        return this.userLimit;
    }

    public float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    public boolean showReservationsAsQueues() {
        return this.showReservationsAsQueues;
    }
}

