/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.activities.ActivitiesManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityHeadroomProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.AbstractContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.allocator.ContainerAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerAllocationProposal;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ContainerRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.PendingAsk;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.ResourceCommitRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.SchedulerContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.AppPlacementAllocator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.placement.CandidateNodeSet;
import org.apache.hadoop.yarn.server.scheduler.SchedulerRequestKey;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FiCaSchedulerApp
extends SchedulerApplicationAttempt {
    private static final Logger LOG = LoggerFactory.getLogger(FiCaSchedulerApp.class);
    private final Set<ContainerId> containersToPreempt = new HashSet<ContainerId>();
    private CapacityHeadroomProvider headroomProvider;
    private ResourceCalculator rc = new DefaultResourceCalculator();
    private ResourceScheduler scheduler;
    private AbstractContainerAllocator containerAllocator;
    private boolean runnable = true;
    private String appSkipNodeDiagnostics;
    private Map<ContainerId, SchedContainerChangeRequest> toBeRemovedIncRequests = new ConcurrentHashMap<ContainerId, SchedContainerChangeRequest>();

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext) {
        this(applicationAttemptId, user, queue, abstractUsersManager, rmContext, Priority.newInstance((int)0), false);
    }

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext, Priority appPriority, boolean isAttemptRecovering) {
        this(applicationAttemptId, user, queue, abstractUsersManager, rmContext, appPriority, isAttemptRecovering, null);
    }

    public FiCaSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, AbstractUsersManager abstractUsersManager, RMContext rmContext, Priority appPriority, boolean isAttemptRecovering, ActivitiesManager activitiesManager) {
        super(applicationAttemptId, user, queue, abstractUsersManager, rmContext);
        String partition;
        Resource amResource;
        RMApp rmApp = (RMApp)rmContext.getRMApps().get(this.getApplicationId());
        if (rmApp == null || rmApp.getAMResourceRequests() == null || rmApp.getAMResourceRequests().isEmpty()) {
            amResource = rmContext.getScheduler().getMinimumResourceCapability();
            partition = "";
        } else {
            amResource = rmApp.getAMResourceRequests().get(0).getCapability();
            partition = rmApp.getAMResourceRequests().get(0).getNodeLabelExpression() == null ? "" : rmApp.getAMResourceRequests().get(0).getNodeLabelExpression();
        }
        this.setAppAMNodePartitionName(partition);
        this.setAMResource(partition, amResource);
        this.setPriority(appPriority);
        this.setAttemptRecovering(isAttemptRecovering);
        this.scheduler = rmContext.getScheduler();
        if (this.scheduler.getResourceCalculator() != null) {
            this.rc = this.scheduler.getResourceCalculator();
        }
        this.updateMultiNodeSortingPolicy(rmApp);
        this.containerAllocator = new ContainerAllocator(this, this.rc, rmContext, activitiesManager);
    }

    private void updateMultiNodeSortingPolicy(RMApp rmApp) {
        if (rmApp == null) {
            return;
        }
        String queueName = null;
        if (this.scheduler instanceof CapacityScheduler) {
            queueName = this.getCSLeafQueue().getMultiNodeSortingPolicyName();
        }
        if (!this.appSchedulingInfo.getApplicationSchedulingEnvs().containsKey("MULTI_NODE_SORTING_POLICY_CLASS") && queueName != null) {
            this.appSchedulingInfo.getApplicationSchedulingEnvs().put("MULTI_NODE_SORTING_POLICY_CLASS", queueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, String partition) {
        this.writeLock.lock();
        try {
            ContainerId containerId = rmContainer.getContainerId();
            if (null == this.liveContainers.remove(containerId)) {
                boolean bl = false;
                return bl;
            }
            this.newlyAllocatedContainers.remove(rmContainer);
            rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
            this.containersToPreempt.remove(containerId);
            String containerPartition = null;
            if (partition != null && !partition.isEmpty()) {
                containerPartition = partition;
            }
            Resource containerResource = rmContainer.getContainer().getResource();
            RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId, containerResource, this.getQueueName(), containerPartition);
            this.queue.getMetrics().releaseResources(partition, this.getUser(), 1, containerResource);
            this.attemptResourceUsage.decUsed(partition, containerResource);
            this.lastMemoryAggregateAllocationUpdateTime = -1L;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMContainer allocate(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Container container) {
        this.readLock.lock();
        try {
            if (this.isStopped) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            if (this.getOutstandingAsksCount(schedulerKey) <= 0) {
                RMContainer rMContainer = null;
                return rMContainer;
            }
            AppPlacementAllocator ps = this.appSchedulingInfo.getAppPlacementAllocator(schedulerKey);
            if (null == ps) {
                LOG.warn("Failed to get " + AppPlacementAllocator.class.getName() + " for application=" + this.getApplicationId() + " schedulerRequestKey=" + schedulerKey);
                RMContainer rMContainer = null;
                return rMContainer;
            }
            RMContainerImpl rmContainer = new RMContainerImpl(container, schedulerKey, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext, ps.getPrimaryRequestedNodePartition());
            String qn = this.getQueueName();
            if (this.scheduler instanceof CapacityScheduler) {
                qn = ((CapacityScheduler)this.scheduler).normalizeQueueName(qn);
            }
            rmContainer.setQueueName(qn);
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ASSIGNED, null);
            RMContainerImpl rMContainerImpl = rmContainer;
            return rMContainerImpl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean rmContainerInFinalState(RMContainer rmContainer) {
        if (null == rmContainer) {
            return false;
        }
        return rmContainer.completed();
    }

    private boolean anyContainerInFinalState(ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request) {
        for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer : request.getContainersToRelease()) {
            if (!this.rmContainerInFinalState(schedulerContainer.getRmContainer())) continue;
            LOG.debug("To-release container={} is in final state", (Object)schedulerContainer.getRmContainer());
            return true;
        }
        for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToAllocate()) {
            for (SchedulerContainer r : containerAllocationProposal.getToRelease()) {
                if (!this.rmContainerInFinalState(r.getRmContainer())) continue;
                LOG.debug("To-release container={}, for to a new allocated container, is in final state", (Object)r.getRmContainer());
                return true;
            }
            if (null == containerAllocationProposal.getAllocateFromReservedContainer() || !this.rmContainerInFinalState(containerAllocationProposal.getAllocateFromReservedContainer().getRmContainer())) continue;
            LOG.debug("Allocate from reserved container {} is in final state", (Object)containerAllocationProposal.getAllocateFromReservedContainer().getRmContainer());
            return true;
        }
        for (ContainerAllocationProposal containerAllocationProposal : request.getContainersToReserve()) {
            for (SchedulerContainer r : containerAllocationProposal.getToRelease()) {
                if (!this.rmContainerInFinalState(r.getRmContainer())) continue;
                LOG.debug("To-release container={}, for a reserved container, is in final state", (Object)r.getRmContainer());
                return true;
            }
        }
        return false;
    }

    private boolean commonCheckContainerAllocation(ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation, SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer) {
        RMContainer reservedContainerOnNode = schedulerContainer.getSchedulerNode().getReservedContainer();
        if (reservedContainerOnNode != null) {
            if (allocation.getAllocateFromReservedContainer() == null) {
                LOG.debug("Trying to allocate from reserved container in async scheduling mode");
                return false;
            }
            RMContainer fromReservedContainer = allocation.getAllocateFromReservedContainer().getRmContainer();
            if (fromReservedContainer != reservedContainerOnNode) {
                LOG.debug("Try to allocate from a non-existed reserved container");
                return false;
            }
        }
        if (allocation.getAllocateFromReservedContainer() != null && reservedContainerOnNode == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to allocate from reserved container " + allocation.getAllocateFromReservedContainer().getRmContainer().getContainerId() + ", but node is not reserved");
            }
            return false;
        }
        Resource availableResource = Resources.clone((Resource)schedulerContainer.getSchedulerNode().getUnallocatedResource());
        if (allocation.getToRelease() != null && !allocation.getToRelease().isEmpty()) {
            for (SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> releaseContainer : allocation.getToRelease()) {
                if (releaseContainer.getRmContainer().getState() == RMContainerState.RESERVED && releaseContainer.getRmContainer() != releaseContainer.getSchedulerNode().getReservedContainer()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to accept this proposal because it tries to release an outdated reserved container " + releaseContainer.getRmContainer().getContainerId() + " on node " + releaseContainer.getSchedulerNode().getNodeID() + " whose reserved container is " + releaseContainer.getSchedulerNode().getReservedContainer());
                    }
                    return false;
                }
                if (releaseContainer.getRmContainer().getState() == RMContainerState.RESERVED || releaseContainer.getSchedulerNode() != schedulerContainer.getSchedulerNode()) continue;
                Resources.addTo((Resource)availableResource, (Resource)releaseContainer.getRmContainer().getAllocatedResource());
            }
        }
        if (!Resources.fitsIn((ResourceCalculator)this.rc, (Resource)allocation.getAllocatedOrReservedResource(), (Resource)availableResource)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Node doesn't have enough available resource, asked=" + allocation.getAllocatedOrReservedResource() + " available=" + availableResource);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request, boolean checkPending) {
        ContainerRequest containerRequest = null;
        boolean reReservation = false;
        this.readLock.lock();
        try {
            if (this.anyContainerInFinalState(request)) {
                boolean bl = false;
                return bl;
            }
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                if (schedulerContainer.getSchedulerNode().getRMNode().getState() != NodeState.RUNNING) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to accept this proposal because node " + schedulerContainer.getSchedulerNode().getNodeID() + " is in " + schedulerContainer.getSchedulerNode().getRMNode().getState() + " state (not RUNNING)");
                    }
                    boolean bl = false;
                    return bl;
                }
                if (schedulerContainer.isAllocated()) {
                    containerRequest = schedulerContainer.getRmContainer().getContainerRequest();
                    if (checkPending && !this.appSchedulingInfo.checkAllocation(allocation.getAllocationLocalityType(), schedulerContainer.getSchedulerNode(), schedulerContainer.getSchedulerRequestKey())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No pending resource for: nodeType=" + (Object)((Object)allocation.getAllocationLocalityType()) + ", node=" + schedulerContainer.getSchedulerNode() + ", requestKey=" + schedulerContainer.getSchedulerRequestKey() + ", application=" + this.getApplicationAttemptId());
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.commonCheckContainerAllocation(allocation, schedulerContainer)) {
                        boolean bl = false;
                        return bl;
                    }
                } else if (schedulerContainer.getRmContainer().getState() == RMContainerState.RESERVED) {
                    if (schedulerContainer.getRmContainer() != schedulerContainer.getSchedulerNode().getReservedContainer()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Try to re-reserve a container, but node " + schedulerContainer.getSchedulerNode() + " is already reserved by another container=" + schedulerContainer.getSchedulerNode().getReservedContainer());
                        }
                        boolean bl = false;
                        return bl;
                    }
                    reReservation = true;
                } else if (schedulerContainer.getSchedulerNode().getReservedContainer() != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Try to reserve a container, but the node is already reserved by another container=" + schedulerContainer.getSchedulerNode().getReservedContainer().getContainerId());
                    }
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        boolean accepted = true;
        if (!reReservation && request.anythingAllocatedOrReserved()) {
            accepted = this.getCSLeafQueue().accept(cluster, request);
        }
        if (!accepted && containerRequest != null) {
            this.recoverResourceRequestsForContainer(containerRequest);
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean apply(Resource cluster, ResourceCommitRequest<FiCaSchedulerApp, FiCaSchedulerNode> request, boolean updatePending) {
        boolean reReservation = false;
        this.writeLock.lock();
        try {
            if (request.anythingAllocatedOrReserved()) {
                ContainerAllocationProposal<FiCaSchedulerApp, FiCaSchedulerNode> allocation = request.getFirstAllocatedOrReservedContainer();
                SchedulerContainer<FiCaSchedulerApp, FiCaSchedulerNode> schedulerContainer = allocation.getAllocatedOrReservedContainer();
                if (updatePending && this.getOutstandingAsksCount(schedulerContainer.getSchedulerRequestKey()) <= 0) {
                    LOG.debug("Rejecting appliance of allocation due to existing pending allocation request for " + schedulerContainer);
                    boolean bl = false;
                    return bl;
                }
                RMContainer rmContainer = schedulerContainer.getRmContainer();
                boolean bl = reReservation = !schedulerContainer.isAllocated() && rmContainer.getState() == RMContainerState.RESERVED;
                if (rmContainer.getContainer().getId() == null) {
                    rmContainer.setContainerId(BuilderUtils.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(), (long)this.getNewContainerId()));
                }
                ContainerId containerId = rmContainer.getContainerId();
                if (schedulerContainer.isAllocated()) {
                    String partition;
                    if (allocation.getAllocateFromReservedContainer() != null) {
                        RMContainer reservedContainer = allocation.getAllocateFromReservedContainer().getRmContainer();
                        this.unreserve(schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getSchedulerNode(), reservedContainer);
                    }
                    this.addToNewlyAllocatedContainers(schedulerContainer.getSchedulerNode(), rmContainer);
                    this.liveContainers.put(containerId, rmContainer);
                    if (updatePending) {
                        ContainerRequest containerRequest = this.appSchedulingInfo.allocate(allocation.getAllocationLocalityType(), schedulerContainer.getSchedulerNode(), schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getRmContainer());
                        ((RMContainerImpl)rmContainer).setContainerRequest(containerRequest);
                        if (containerRequest != null && containerRequest.getSchedulingRequest() != null) {
                            ((RMContainerImpl)rmContainer).setAllocationTags(containerRequest.getSchedulingRequest().getAllocationTags());
                        }
                    } else {
                        AppSchedulingInfo.updateMetrics(this.getApplicationId(), allocation.getAllocationLocalityType(), schedulerContainer.getSchedulerNode(), schedulerContainer.getRmContainer(), this.getUser(), this.getQueue());
                    }
                    this.attemptResourceUsage.incUsed(schedulerContainer.getNodePartition(), allocation.getAllocatedOrReservedResource());
                    rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.START));
                    schedulerContainer.getSchedulerNode().allocateContainer(rmContainer);
                    this.incNumAllocatedContainers(allocation.getAllocationLocalityType(), allocation.getRequestLocalityType());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("allocate: applicationAttemptId=" + containerId.getApplicationAttemptId() + " container=" + containerId + " host=" + rmContainer.getAllocatedNode().getHost() + " type=" + (Object)((Object)allocation.getAllocationLocalityType()));
                    }
                    if ((partition = schedulerContainer.getSchedulerNode().getPartition()) != null && partition.isEmpty()) {
                        partition = null;
                    }
                    RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), containerId, allocation.getAllocatedOrReservedResource(), this.getQueueName(), partition);
                } else {
                    this.reserve(schedulerContainer.getSchedulerRequestKey(), schedulerContainer.getSchedulerNode(), schedulerContainer.getRmContainer(), schedulerContainer.getRmContainer().getContainer(), reReservation);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Reserved container=" + rmContainer.getContainerId() + ", on node=" + schedulerContainer.getSchedulerNode() + " with resource=" + rmContainer.getAllocatedOrReservedResource());
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (!reReservation) {
            this.getCSLeafQueue().apply(cluster, request);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unreserve(SchedulerRequestKey schedulerKey, FiCaSchedulerNode node, RMContainer rmContainer) {
        this.writeLock.lock();
        try {
            if (this.internalUnreserve(node, schedulerKey)) {
                node.unreserveResource(this);
                this.queue.getMetrics().unreserveResource(node.getPartition(), this.getUser(), rmContainer.getReservedResource());
                this.queue.decReservedResource(node.getPartition(), rmContainer.getReservedResource());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean internalUnreserve(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey) {
        RMContainer reservedContainer;
        Map reservedContainers = (Map)this.reservedContainers.get(schedulerKey);
        if (reservedContainers != null && (reservedContainer = (RMContainer)reservedContainers.remove(node.getNodeID())) != null && reservedContainer.getContainer() != null && reservedContainer.getContainer().getResource() != null) {
            if (reservedContainers.isEmpty()) {
                this.reservedContainers.remove(schedulerKey);
            }
            this.resetReReservations(schedulerKey);
            Resource resource = reservedContainer.getReservedResource();
            this.attemptResourceUsage.decReserved(node.getPartition(), resource);
            LOG.info("Application " + this.getApplicationId() + " unreserved  on node " + node + ", currently has " + reservedContainers.size() + " at priority " + schedulerKey.getPriority() + "; currentReservation " + this.attemptResourceUsage.getReserved(node.getPartition()) + " on node-label=" + node.getPartition());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Resource> getTotalPendingRequestsPerPartition() {
        this.readLock.lock();
        try {
            HashMap<String, Resource> ret = new HashMap<String, Resource>();
            for (SchedulerRequestKey schedulerKey : this.appSchedulingInfo.getSchedulerKeys()) {
                PendingAsk ask;
                AppPlacementAllocator ps = this.appSchedulingInfo.getAppPlacementAllocator(schedulerKey);
                String nodePartition = ps.getPrimaryRequestedNodePartition();
                Resource res = (Resource)ret.get(nodePartition);
                if (null == res) {
                    res = Resources.createResource((int)0);
                    ret.put(nodePartition, res);
                }
                if ((ask = ps.getPendingAsk("*")).getCount() <= 0) continue;
                Resources.addTo((Resource)res, (Resource)Resources.multiply((Resource)ask.getPerAllocationResource(), (double)ask.getCount()));
            }
            HashMap<String, Resource> hashMap = ret;
            return hashMap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void markContainerForPreemption(ContainerId cont) {
        this.writeLock.lock();
        try {
            if (this.liveContainers.containsKey(cont)) {
                this.containersToPreempt.add(cont);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation getAllocation(ResourceCalculator resourceCalculator, Resource clusterResource, Resource minimumAllocation) {
        this.writeLock.lock();
        try {
            Set<ContainerId> currentContPreemption = Collections.unmodifiableSet(new HashSet<ContainerId>(this.containersToPreempt));
            this.containersToPreempt.clear();
            Resource tot = Resource.newInstance((int)0, (int)0);
            for (ContainerId c : currentContPreemption) {
                Resources.addTo((Resource)tot, (Resource)((RMContainer)this.liveContainers.get(c)).getContainer().getResource());
            }
            int numCont = (int)Math.ceil(Resources.divide((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tot, (Resource)minimumAllocation));
            ResourceRequest rr = ResourceRequest.newBuilder().priority(Priority.UNDEFINED).resourceName("*").capability(minimumAllocation).numContainers(numCont).build();
            List<Container> previousAttemptContainers = this.pullPreviousAttemptContainers();
            List<Container> newlyAllocatedContainers = this.pullNewlyAllocatedContainers();
            List<Container> newlyIncreasedContainers = this.pullNewlyIncreasedContainers();
            List<Container> newlyDecreasedContainers = this.pullNewlyDecreasedContainers();
            List<Container> newlyPromotedContainers = this.pullNewlyPromotedContainers();
            List<Container> newlyDemotedContainers = this.pullNewlyDemotedContainers();
            List<NMToken> updatedNMTokens = this.pullUpdatedNMTokens();
            Resource headroom = this.getHeadroom();
            this.setApplicationHeadroomForMetrics(headroom);
            Allocation allocation = new Allocation(newlyAllocatedContainers, headroom, null, currentContPreemption, Collections.singletonList(rr), updatedNMTokens, newlyIncreasedContainers, newlyDecreasedContainers, newlyPromotedContainers, newlyDemotedContainers, previousAttemptContainers, this.appSchedulingInfo.getRejectedRequest());
            return allocation;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @VisibleForTesting
    public NodeId getNodeIdToUnreserve(SchedulerRequestKey schedulerKey, Resource resourceNeedUnreserve, ResourceCalculator resourceCalculator) {
        Map reservedContainers = (Map)this.reservedContainers.get(schedulerKey);
        if (reservedContainers != null && !reservedContainers.isEmpty()) {
            for (Map.Entry entry : reservedContainers.entrySet()) {
                NodeId nodeId = (NodeId)entry.getKey();
                RMContainer reservedContainer = (RMContainer)entry.getValue();
                Resource reservedResource = reservedContainer.getReservedResource();
                if (!Resources.fitsIn((ResourceCalculator)resourceCalculator, (Resource)resourceNeedUnreserve, (Resource)reservedResource)) continue;
                LOG.debug("unreserving node with reservation size: {} in order to allocate container with size: {}", (Object)reservedResource, (Object)resourceNeedUnreserve);
                return nodeId;
            }
        }
        return null;
    }

    public void setHeadroomProvider(CapacityHeadroomProvider headroomProvider) {
        this.writeLock.lock();
        try {
            this.headroomProvider = headroomProvider;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Resource getHeadroom() {
        this.readLock.lock();
        try {
            if (this.headroomProvider != null) {
                Resource resource = this.headroomProvider.getHeadroom();
                return resource;
            }
            Resource resource = super.getHeadroom();
            return resource;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        this.writeLock.lock();
        try {
            super.transferStateFromPreviousAttempt(appAttempt);
            this.headroomProvider = ((FiCaSchedulerApp)appAttempt).headroomProvider;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reserve(SchedulerRequestKey schedulerKey, FiCaSchedulerNode node, RMContainer rmContainer, Container container, boolean reReservation) {
        if (!reReservation) {
            this.queue.getMetrics().reserveResource(node.getPartition(), this.getUser(), container.getResource());
        }
        rmContainer = super.reserve(node, schedulerKey, rmContainer, container);
        node.reserveResource(this, schedulerKey, rmContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public RMContainer findNodeToUnreserve(FiCaSchedulerNode node, SchedulerRequestKey schedulerKey, Resource minimumUnreservedResource) {
        this.readLock.lock();
        try {
            NodeId idToUnreserve = this.getNodeIdToUnreserve(schedulerKey, minimumUnreservedResource, this.rc);
            if (idToUnreserve == null) {
                LOG.debug("checked to see if could unreserve for app but nothing reserved that matches for this app");
                RMContainer rMContainer = null;
                return rMContainer;
            }
            FiCaSchedulerNode nodeToUnreserve = ((CapacityScheduler)this.scheduler).getNode(idToUnreserve);
            if (nodeToUnreserve == null) {
                LOG.error("node to unreserve doesn't exist, nodeid: " + idToUnreserve);
                RMContainer rMContainer = null;
                return rMContainer;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("unreserving for app: " + this.getApplicationId() + " on nodeId: " + idToUnreserve + " in order to replace reserved application and place it on node: " + node.getNodeID() + " needing: " + minimumUnreservedResource);
            }
            Resources.addTo((Resource)this.getHeadroom(), (Resource)nodeToUnreserve.getReservedContainer().getReservedResource());
            RMContainer rMContainer = nodeToUnreserve.getReservedContainer();
            return rMContainer;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public LeafQueue getCSLeafQueue() {
        return (LeafQueue)this.queue;
    }

    public CSAssignment assignContainers(Resource clusterResource, CandidateNodeSet<FiCaSchedulerNode> ps, ResourceLimits currentResourceLimits, SchedulingMode schedulingMode, RMContainer reservedContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("pre-assignContainers for application " + this.getApplicationId());
            this.showRequests();
        }
        return this.containerAllocator.assignContainers(clusterResource, ps, schedulingMode, currentResourceLimits, reservedContainer);
    }

    public void nodePartitionUpdated(RMContainer rmContainer, String oldPartition, String newPartition) {
        Resource containerResource = rmContainer.getAllocatedResource();
        this.attemptResourceUsage.decUsed(oldPartition, containerResource);
        this.attemptResourceUsage.incUsed(newPartition, containerResource);
        this.getCSLeafQueue().decUsedResource(oldPartition, containerResource, this);
        this.getCSLeafQueue().incUsedResource(newPartition, containerResource, this);
        if (rmContainer.isAMContainer()) {
            this.setAppAMNodePartitionName(newPartition);
            this.attemptResourceUsage.decAMUsed(oldPartition, containerResource);
            this.attemptResourceUsage.incAMUsed(newPartition, containerResource);
            this.getCSLeafQueue().decAMUsedResource(oldPartition, containerResource, this);
            this.getCSLeafQueue().incAMUsedResource(newPartition, containerResource, this);
        }
    }

    @Override
    protected void getPendingAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        diagnosticMessage.append(" Details : AM Partition = ").append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName).append("; ").append("AM Resource Request = ").append(this.getAMResource(this.appAMNodePartitionName)).append("; ").append("Queue Resource Limit for AM = ").append(queue.getAMResourceLimitPerPartition(this.appAMNodePartitionName)).append("; ").append("User AM Resource Limit of the queue = ").append(queue.getUserAMResourceLimitPerPartition(this.appAMNodePartitionName, this.getUser())).append("; ").append("Queue AM Resource Usage = ").append(queue.getQueueResourceUsage().getAMUsed(this.appAMNodePartitionName)).append("; ");
    }

    @Override
    protected void getActivedAppDiagnosticMessage(StringBuilder diagnosticMessage) {
        LeafQueue queue = this.getCSLeafQueue();
        QueueCapacities queueCapacities = queue.getQueueCapacities();
        QueueResourceQuotas queueResourceQuotas = queue.getQueueResourceQuotas();
        diagnosticMessage.append(" Details : AM Partition = ").append(this.appAMNodePartitionName.isEmpty() ? "<DEFAULT_PARTITION>" : this.appAMNodePartitionName).append(" ; ").append("Partition Resource = ").append(this.rmContext.getNodeLabelManager().getResourceByLabel(this.appAMNodePartitionName, Resources.none())).append(" ; ").append("Queue's Absolute capacity = ").append(queueCapacities.getAbsoluteCapacity(this.appAMNodePartitionName) * 100.0f).append(" % ; ").append("Queue's Absolute used capacity = ").append(queueCapacities.getAbsoluteUsedCapacity(this.appAMNodePartitionName) * 100.0f).append(" % ; ").append("Queue's Absolute max capacity = ").append(queueCapacities.getAbsoluteMaximumCapacity(this.appAMNodePartitionName) * 100.0f).append(" % ; ").append("Queue's capacity (absolute resource) = ").append(queueResourceQuotas.getEffectiveMinResource(this.appAMNodePartitionName)).append(" ; ").append("Queue's used capacity (absolute resource) = ").append(queue.getQueueResourceUsage().getUsed(this.appAMNodePartitionName)).append(" ; ").append("Queue's max capacity (absolute resource) = ").append(queueResourceQuotas.getEffectiveMaxResource(this.appAMNodePartitionName)).append(" ; ");
    }

    public void updateAppSkipNodeDiagnostics(String message) {
        this.appSkipNodeDiagnostics = message;
    }

    public void updateNodeInfoForAMDiagnostics(FiCaSchedulerNode node) {
        if (null == node) {
            return;
        }
        if (this.isWaitingForAMContainer()) {
            StringBuilder diagnosticMessageBldr = new StringBuilder();
            if (this.appSkipNodeDiagnostics != null) {
                diagnosticMessageBldr.append(this.appSkipNodeDiagnostics);
                this.appSkipNodeDiagnostics = null;
            }
            diagnosticMessageBldr.append(" Last Node which was processed for the application : ").append(node.getNodeID()).append(" ( Partition : ").append(node.getLabels()).append(", Total resource : ").append(node.getTotalResource()).append(", Available resource : ").append(node.getUnallocatedResource()).append(" ).");
            this.updateAMContainerDiagnostics(SchedulerApplicationAttempt.AMState.ACTIVATED, diagnosticMessageBldr.toString());
        }
    }

    public AppPlacementAllocator<FiCaSchedulerNode> getAppPlacementAllocator(SchedulerRequestKey schedulerRequestKey) {
        return super.getAppPlacementAllocator(schedulerRequestKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getResourceUsageReport() {
        this.writeLock.lock();
        try {
            ApplicationResourceUsageReport report = super.getResourceUsageReport();
            Resource cluster = this.rmContext.getScheduler().getClusterResource();
            Resource totalPartitionRes = this.rmContext.getNodeLabelManager().getResourceByLabel(this.getAppAMNodePartitionName(), cluster);
            ResourceCalculator calc = this.rmContext.getScheduler().getResourceCalculator();
            float queueUsagePerc = 0.0f;
            if (!calc.isAllInvalidDivisor(totalPartitionRes)) {
                Resource effCap = ((AbstractCSQueue)this.getQueue()).getEffectiveCapacity(this.getAppAMNodePartitionName());
                if (!effCap.equals((Object)Resources.none())) {
                    queueUsagePerc = calc.divide(totalPartitionRes, report.getUsedResources(), effCap) * 100.0f;
                }
                report.setQueueUsagePercentage(queueUsagePerc);
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = report;
            return applicationResourceUsageReport;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.writeLock;
    }

    public void addToBeRemovedIncreaseRequest(SchedContainerChangeRequest request) {
        this.toBeRemovedIncRequests.put(request.getContainerId(), request);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean moveReservation(RMContainer reservedContainer, FiCaSchedulerNode sourceNode, FiCaSchedulerNode targetNode) {
        Map map;
        block14: {
            this.writeLock.lock();
            try {
                if (!sourceNode.getPartition().equals(targetNode.getPartition())) {
                    LOG.debug("Failed to move reservation, two nodes are in different partition");
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
                map = (Map)this.reservedContainers.get(reservedContainer.getReservedSchedulerKey());
                if (null == map) {
                    LOG.debug("Cannot find reserved container map.");
                    boolean bl = false;
                    this.writeLock.unlock();
                    return bl;
                }
                if (sourceNode.getReservedContainer() == reservedContainer) break block14;
                LOG.debug("To-be-moved container already updated.");
                boolean bl = false;
                this.writeLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        FiCaSchedulerNode fiCaSchedulerNode = targetNode;
        // MONITORENTER : fiCaSchedulerNode
        if (targetNode.getReservedContainer() != null) {
            LOG.debug("Target node is already occupied before moving");
        }
        try {
            targetNode.reserveResource(this, reservedContainer.getReservedSchedulerKey(), reservedContainer);
        }
        catch (IllegalStateException e) {
            LOG.debug("Reserve on target node failed, e={}", (Throwable)e);
            boolean bl = false;
            // MONITOREXIT : fiCaSchedulerNode
            this.writeLock.unlock();
            return bl;
        }
        sourceNode.setReservedContainer(null);
        map.remove(sourceNode.getNodeID());
        reservedContainer.handle((Event)new RMContainerReservedEvent(reservedContainer.getContainerId(), reservedContainer.getReservedResource(), targetNode.getNodeID(), reservedContainer.getReservedSchedulerKey()));
        map.put(targetNode.getNodeID(), reservedContainer);
        boolean bl = true;
        // MONITOREXIT : fiCaSchedulerNode
        this.writeLock.unlock();
        return bl;
    }

    public void setRunnable(boolean runnable) {
        this.writeLock.lock();
        try {
            this.runnable = runnable;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isRunnable() {
        this.readLock.lock();
        try {
            boolean bl = this.runnable;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

