/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableScan;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableScanner
extends AbstractTestAsyncTableScan {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableScanner.class);
    @Parameterized.Parameter(value=0)
    public String tableType;
    @Parameterized.Parameter(value=1)
    public Supplier<AsyncTable<?>> getTable;
    @Parameterized.Parameter(value=2)
    public String scanType;
    @Parameterized.Parameter(value=3)
    public Supplier<Scan> scanCreator;

    @Parameterized.Parameters(name="{index}: table={0}, scan={2}")
    public static List<Object[]> params() {
        return TestAsyncTableScanner.getTableAndScanCreatorParams();
    }

    @Override
    protected Scan createScan() {
        return this.scanCreator.get();
    }

    @Override
    protected List<Result> doScan(Scan scan) throws Exception {
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
        List<Result> results = new ArrayList<Result>();
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result;
            while ((result = scanner.next()) != null) {
                results.add(result);
            }
        }
        if (scan.getBatch() > 0) {
            results = this.convertFromBatchResult(results);
        }
        return results;
    }
}

