/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import org.apache.hadoop.hbase.master.balancer.HeterogeneousRegionCountCostFunction;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.TestStochasticLoadBalancerHeterogeneousCostRules;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestStochasticLoadBalancerHeterogeneousCost
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerHeterogeneousCost.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestStochasticLoadBalancerHeterogeneousCost.class);
    private static final double ALLOWED_WINDOW = 1.2;
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();
    private static String RULES_FILE;
    private Queue<ServerName> serverQueue = new LinkedList<ServerName>();

    @BeforeClass
    public static void beforeAllTests() throws IOException {
        BalancerTestBase.conf = HTU.getConfiguration();
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.regionCountCost", 0.0f);
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.primaryRegionCountCost", 0.0f);
        BalancerTestBase.conf.setFloat("hbase.master.balancer.stochastic.tableSkewCost", 0.0f);
        BalancerTestBase.conf.set("hbase.master.balancer.stochastic.additionalCostFunctions", HeterogeneousRegionCountCostFunction.class.getName());
        TestCase.assertTrue((boolean)FileSystem.get((Configuration)HTU.getConfiguration()).mkdirs(HTU.getDataTestDir()));
        RULES_FILE = HTU.getDataTestDir("hbase-balancer.rules").toString();
        BalancerTestBase.conf.set("hbase.master.balancer.heterogeneousRegionCountRulesFile", RULES_FILE);
        BalancerTestBase.loadBalancer = new StochasticLoadTestBalancer();
        BalancerTestBase.loadBalancer.setConf(BalancerTestBase.conf);
        BalancerTestBase.loadBalancer.getCandidateGenerators().add(new FairRandomCandidateGenerator());
    }

    @Test
    public void testDefault() throws IOException {
        List<String> rules = Collections.emptyList();
        int numNodes = 2;
        int numRegions = 300;
        int numRegionsPerServer = 250;
        this.testHeterogeneousWithCluster(2, 300, 250, rules);
    }

    @Test
    public void testOneGroup() throws IOException {
        List<String> rules = Collections.singletonList("rs.* 100");
        int numNodes = 4;
        int numRegions = 300;
        int numRegionsPerServer = 30;
        this.testHeterogeneousWithCluster(4, 300, 30, rules);
    }

    @Test
    public void testTwoGroups() throws IOException {
        List<String> rules = Arrays.asList("rs[0-4] 200", "rs[5-9] 50");
        int numNodes = 10;
        int numRegions = 500;
        int numRegionsPerServer = 50;
        this.testHeterogeneousWithCluster(10, 500, 50, rules);
    }

    @Test
    public void testFourGroups() throws IOException {
        List<String> rules = Arrays.asList("rs[1-3] 200", "rs[4-7] 250", "rs[8-9] 100");
        int numNodes = 10;
        int numRegions = 800;
        int numRegionsPerServer = 80;
        this.testHeterogeneousWithCluster(10, 800, 80, rules);
    }

    @Test
    public void testOverloaded() throws IOException {
        List<String> rules = Collections.singletonList("rs[0-1] 50");
        int numNodes = 2;
        int numRegions = 120;
        int numRegionsPerServer = 60;
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(RULES_FILE);
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(2, 120, 60, 1, 1);
        List plans = BalancerTestBase.loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
        Assert.assertNull((Object)plans);
    }

    private void testHeterogeneousWithCluster(int numNodes, int numRegions, int numRegionsPerServer, List<String> rules) throws IOException {
        TestStochasticLoadBalancerHeterogeneousCostRules.createRulesFile(RULES_FILE, rules);
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, 1, 1);
        this.testWithCluster(serverMap, null, true, false);
    }

    @Override
    protected void testWithCluster(Map<ServerName, List<RegionInfo>> serverMap, RackManager rackManager, boolean assertFullyBalanced, boolean assertFullyBalancedForReplicas) {
        List<ServerAndLoad> list = this.convertToList(serverMap);
        LOG.info("Mock Cluster : " + this.printMock(list) + " " + this.printStats(list));
        BalancerTestBase.loadBalancer.setRackManager(rackManager);
        List plans = BalancerTestBase.loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
        TestCase.assertNotNull((Object)plans);
        if (assertFullyBalanced || assertFullyBalancedForReplicas) {
            List<ServerAndLoad> balancedCluster = this.reconcile(list, plans, serverMap);
            LOG.info("Mock Balanced cluster : " + this.printMock(balancedCluster));
            if (assertFullyBalanced) {
                List secondPlans = BalancerTestBase.loadBalancer.balanceTable(HConstants.ENSEMBLE_TABLE_NAME, serverMap);
                Assert.assertNull((Object)secondPlans);
                HeterogeneousRegionCountCostFunction cf = new HeterogeneousRegionCountCostFunction(conf);
                TestCase.assertNotNull((Object)cf);
                BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(serverMap, null, null, null);
                cf.init(cluster);
                for (ServerAndLoad serverAndLoad : balancedCluster) {
                    ServerName sn = serverAndLoad.getServerName();
                    int numberRegions = serverAndLoad.getLoad();
                    int limit = cf.findLimitForRS(sn);
                    double usage = (double)numberRegions / (double)limit;
                    LOG.debug(sn.getHostname() + ":" + numberRegions + "/" + limit + "(" + usage * 100.0 + "%)");
                    TestCase.assertTrue((String)("Host " + sn.getHostname() + " should be below " + cf.overallUsage * 1.2 * 100.0 + "%; " + cf.overallUsage + ", " + usage + ", " + numberRegions + ", " + limit), (usage <= cf.overallUsage * 1.2 ? 1 : 0) != 0);
                }
            }
            if (assertFullyBalancedForReplicas) {
                this.assertRegionReplicaPlacement(serverMap, rackManager);
            }
        }
    }

    @Override
    protected Map<ServerName, List<RegionInfo>> createServerMap(int numNodes, int numRegions, int numRegionsPerServer, int replication, int numTables) {
        int[] cluster = new int[numNodes];
        for (int i = 0; i < numNodes; ++i) {
            cluster[i] = numRegionsPerServer;
        }
        cluster[cluster.length - 1] = numRegions - (cluster.length - 1) * numRegionsPerServer;
        TreeMap<ServerName, List<RegionInfo>> clusterState = this.mockClusterServers(cluster, numTables);
        if (replication > 0) {
            for (List regions : clusterState.values()) {
                int length = regions.size();
                for (int i = 0; i < length; ++i) {
                    for (int r = 1; r < replication; ++r) {
                        regions.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)((RegionInfo)regions.get(i)), (int)r));
                    }
                }
            }
        }
        return clusterState;
    }

    @Override
    protected TreeMap<ServerName, List<RegionInfo>> mockClusterServers(int[] mockCluster, int numTables) {
        int numServers = mockCluster.length;
        TreeMap<ServerName, List<RegionInfo>> servers = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            ServerAndLoad sal = this.createServer("rs" + i);
            List<RegionInfo> regions = this.randomRegions(numRegions, numTables);
            servers.put(sal.getServerName(), regions);
        }
        return servers;
    }

    private ServerAndLoad createServer(String host) {
        if (!this.serverQueue.isEmpty()) {
            ServerName sn = this.serverQueue.poll();
            return new ServerAndLoad(sn, 0);
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int port = ((Random)rand).nextInt(60000);
        long startCode = ((Random)rand).nextLong();
        ServerName sn = ServerName.valueOf((String)host, (int)port, (long)startCode);
        return new ServerAndLoad(sn, 0);
    }

    static class StochasticLoadTestBalancer
    extends StochasticLoadBalancer {
        private FairRandomCandidateGenerator fairRandomCandidateGenerator = new FairRandomCandidateGenerator();

        StochasticLoadTestBalancer() {
        }

        protected CandidateGenerator getRandomGenerator() {
            return this.fairRandomCandidateGenerator;
        }
    }

    static class FairRandomCandidateGenerator
    extends StochasticLoadBalancer.RandomCandidateGenerator {
        FairRandomCandidateGenerator() {
        }

        public BaseLoadBalancer.Cluster.Action pickRandomRegions(BaseLoadBalancer.Cluster cluster, int thisServer, int otherServer) {
            if (thisServer < 0 || otherServer < 0) {
                return BaseLoadBalancer.Cluster.NullAction;
            }
            int thisRegion = this.pickRandomRegion(cluster, thisServer, 0.5);
            int otherRegion = this.pickRandomRegion(cluster, otherServer, 0.5);
            return this.getAction(thisServer, thisRegion, otherServer, otherRegion);
        }

        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            return super.generate(cluster);
        }
    }
}

